/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.parser.FieldParser;

@PublicEvolving
public class StringValueParser
extends FieldParser<StringValue> {
    private boolean quotedStringParsing = false;
    private byte quoteCharacter;
    private static final byte BACKSLASH = 92;
    private StringValue result;

    public void enableQuotedStringParsing(byte quoteCharacter) {
        this.quotedStringParsing = true;
        this.quoteCharacter = quoteCharacter;
    }

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, StringValue reusable) {
        int i;
        if (startPos == limit) {
            this.setErrorState(FieldParser.ParseErrorState.EMPTY_COLUMN);
            reusable.setValueAscii(bytes, startPos, 0);
            return limit;
        }
        this.result = reusable;
        int delimLimit = limit - delimiter.length + 1;
        if (this.quotedStringParsing && bytes[i] == this.quoteCharacter) {
            ++i;
            while (i < limit && (bytes[i] != this.quoteCharacter || bytes[i - 1] == 92)) {
                ++i;
            }
            if (i == limit) {
                this.setErrorState(FieldParser.ParseErrorState.UNTERMINATED_QUOTED_STRING);
                return -1;
            }
            if (++i == limit) {
                reusable.setValueAscii(bytes, startPos + 1, i - startPos - 2);
                return limit;
            }
            if (i < delimLimit && StringValueParser.delimiterNext(bytes, i, delimiter)) {
                reusable.setValueAscii(bytes, startPos + 1, i - startPos - 2);
                return i + delimiter.length;
            }
            this.setErrorState(FieldParser.ParseErrorState.UNQUOTED_CHARS_AFTER_QUOTED_STRING);
            return -1;
        }
        for (i = startPos; i < delimLimit && !StringValueParser.delimiterNext(bytes, i, delimiter); ++i) {
        }
        if (i >= delimLimit) {
            reusable.setValueAscii(bytes, startPos, limit - startPos);
            return limit;
        }
        if (i == startPos) {
            this.setErrorState(FieldParser.ParseErrorState.EMPTY_COLUMN);
        }
        reusable.setValueAscii(bytes, startPos, i - startPos);
        return i + delimiter.length;
    }

    @Override
    public StringValue createValue() {
        return new StringValue();
    }

    @Override
    public StringValue getLastResult() {
        return this.result;
    }
}

