/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sqlfileoutput;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.sqlfileoutput.SQLFileOutput;
import org.apache.hop.pipeline.transforms.sqlfileoutput.SQLFileOutputData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.w3c.dom.Node;

@Transform(id="SQLFileOutput", image="sqlfileoutput.svg", name="i18n::SQLFileOutput.Name", description="i18n::SQLFileOutput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", keywords={"i18n::SQLFileOutputMeta.keyword"}, documentationUrl="/pipeline/transforms/sqlfileoutput.html")
public class SQLFileOutputMeta
extends BaseTransformMeta<SQLFileOutput, SQLFileOutputData> {
    private static final Class<?> PKG = SQLFileOutputMeta.class;
    private static final String CONST_SPACE = "      ";
    private static final String CONST_SPACE_SHORT = "    ";
    @HopMetadataProperty(key="connection")
    private String connection;
    @HopMetadataProperty(key="schema")
    private String schemaName;
    @HopMetadataProperty(key="table")
    private String tableName;
    @HopMetadataProperty(key="truncate")
    private boolean truncateTable;
    @HopMetadataProperty(key="AddToResult")
    private boolean addToResult;
    @HopMetadataProperty(key="create")
    private boolean createTable;
    @HopMetadataProperty(key="file")
    private SqlFile file;
    @HopMetadataProperty(key="encoding")
    private String encoding;
    @HopMetadataProperty(key="dateformat")
    private String dateFormat;
    @HopMetadataProperty(key="StartNewLine")
    private boolean startNewLine;

    @Deprecated(since="2.13")
    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            super.loadXml(transformNode, metadataProvider);
            this.file.extension = XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"extention");
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public String[] getFiles(IVariables variables, String fileName) {
        int nr;
        int copies = 1;
        int splits = 1;
        int parts = 1;
        if (this.file.transformNrInFilename) {
            copies = 3;
        }
        if (this.file.partNrInFilename) {
            parts = 3;
        }
        if (this.file.splitEvery != 0) {
            splits = 3;
        }
        if ((nr = copies * parts * splits) > 1) {
            ++nr;
        }
        String[] retval = new String[nr];
        int i = 0;
        for (int copy = 0; copy < copies; ++copy) {
            for (int part = 0; part < parts; ++part) {
                for (int split = 0; split < splits; ++split) {
                    retval[i] = this.buildFilename(variables, fileName, copy, split);
                    ++i;
                }
            }
        }
        if (i < nr) {
            retval[i] = "...";
        }
        return retval;
    }

    public String buildFilename(IVariables variables, String fileName, int transformnr, int splitnr) {
        SimpleDateFormat daf = new SimpleDateFormat();
        Object retval = fileName;
        Date now = new Date();
        if (this.file.dateInFilename) {
            daf.applyPattern("yyyMMdd");
            String d = daf.format(now);
            retval = (String)retval + "_" + d;
        }
        if (this.file.timeInFilename) {
            daf.applyPattern("HHmmss");
            String t = daf.format(now);
            retval = (String)retval + "_" + t;
        }
        if (this.file.transformNrInFilename) {
            retval = (String)retval + "_" + transformnr;
        }
        if (this.file.splitEvery > 0) {
            retval = (String)retval + "_" + splitnr;
        }
        if (!Utils.isEmpty((CharSequence)this.file.extension)) {
            retval = (String)retval + "." + variables.resolve(this.file.extension);
        }
        return retval;
    }

    public void setDefault() {
        this.file = new SqlFile();
        this.connection = "";
        this.tableName = "";
        this.file.createParentFolder = false;
        this.file.doNotOpenNewFileInit = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        block27: {
            Database db = null;
            try {
                DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
                if (databaseMeta != null) {
                    CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.ConnectionExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    db = new Database(loggingObject, variables, databaseMeta);
                    try {
                        db.connect();
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.ConnectionOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        if (!Utils.isEmpty((CharSequence)this.tableName)) {
                            String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                            if (db.checkTableExists(this.schemaName, this.tableName)) {
                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.TableAccessible", (String[])new String[]{schemaTable}), (ICheckResultSource)transformMeta);
                                remarks.add((ICheckResult)cr);
                                IRowMeta r = db.getTableFieldsMeta(this.schemaName, this.tableName);
                                if (r != null) {
                                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.TableOk", (String[])new String[]{schemaTable}), (ICheckResultSource)transformMeta);
                                    remarks.add((ICheckResult)cr);
                                    Object errorMessage = "";
                                    boolean errorFound = false;
                                    if (prev != null && !prev.isEmpty()) {
                                        int idx;
                                        int i;
                                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
                                        remarks.add((ICheckResult)cr);
                                        for (i = 0; i < prev.size(); ++i) {
                                            IValueMeta pv = prev.getValueMeta(i);
                                            idx = r.indexOfValue(pv.getName());
                                            if (idx >= 0) continue;
                                            errorMessage = (String)errorMessage + "\t\t" + pv.getName() + " (" + pv.getTypeDesc() + ")" + Const.CR;
                                            errorFound = true;
                                        }
                                        if (errorFound) {
                                            errorMessage = BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.FieldsNotFoundInOutput", (String[])new String[]{errorMessage});
                                            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                                            remarks.add((ICheckResult)cr);
                                        } else {
                                            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.AllFieldsFoundInOutput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                            remarks.add((ICheckResult)cr);
                                        }
                                        for (i = 0; i < r.size(); ++i) {
                                            IValueMeta rv = r.getValueMeta(i);
                                            idx = prev.indexOfValue(rv.getName());
                                            if (idx >= 0) continue;
                                            errorMessage = (String)errorMessage + "\t\t" + rv.getName() + " (" + rv.getTypeDesc() + ")" + Const.CR;
                                            errorFound = true;
                                        }
                                        if (errorFound) {
                                            errorMessage = BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.FieldsNotFound", (String[])new String[]{errorMessage});
                                            cr = new CheckResult(3, (String)errorMessage, (ICheckResultSource)transformMeta);
                                            remarks.add((ICheckResult)cr);
                                        } else {
                                            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                            remarks.add((ICheckResult)cr);
                                        }
                                    } else {
                                        cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.NoFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                        remarks.add((ICheckResult)cr);
                                    }
                                } else {
                                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.TableNotAccessible", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                    remarks.add((ICheckResult)cr);
                                }
                            } else {
                                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.TableError", (String[])new String[]{schemaTable}), (ICheckResultSource)transformMeta);
                                remarks.add((ICheckResult)cr);
                            }
                        } else {
                            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.NoTableName", (String[])new String[0]), (ICheckResultSource)transformMeta);
                            remarks.add((ICheckResult)cr);
                        }
                        break block27;
                    }
                    catch (HopException e) {
                        cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.UndefinedError", (String[])new String[]{e.getMessage()}), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        break block27;
                    }
                    finally {
                        db.disconnect();
                    }
                }
                CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.NoConnection", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                String errorMessage = BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                CheckResult cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        DatabaseMeta databaseMeta = null;
        try {
            databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
            if (this.truncateTable) {
                DatabaseImpact ii = new DatabaseImpact(4, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), this.tableName, "", "", "", "", "Truncate of table");
                impact.add(ii);
            }
            if (prev != null) {
                for (int i = 0; i < prev.size(); ++i) {
                    IValueMeta v = prev.getValueMeta(i);
                    DatabaseImpact ii = new DatabaseImpact(2, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), this.tableName, v.getName(), v.getName(), v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
            }
        }
        catch (HopException e) {
            throw new HopTransformException("Unable to get databaseMeta for connection: " + Const.CR + variables.resolve(this.connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) {
        SqlStatement retVal;
        block11: {
            retVal = null;
            try {
                DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
                retVal = new SqlStatement(transformMeta.getName(), databaseMeta, null);
                if (databaseMeta != null) {
                    if (prev != null && !prev.isEmpty()) {
                        if (!Utils.isEmpty((CharSequence)this.tableName)) {
                            Database db = new Database(loggingObject, variables, databaseMeta);
                            try {
                                db.connect();
                                String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                                String crTable = db.getDDL(schemaTable, prev);
                                if (Utils.isEmpty((CharSequence)crTable)) {
                                    crTable = null;
                                }
                                retVal.setSql(crTable);
                                break block11;
                            }
                            catch (HopDatabaseException dbe) {
                                retVal.setError(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.Error.ErrorConnecting", (String[])new String[]{dbe.getMessage()}));
                                break block11;
                            }
                            finally {
                                db.disconnect();
                            }
                        }
                        retVal.setError(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.Exception.TableNotSpecified", (String[])new String[0]));
                        break block11;
                    }
                    retVal.setError(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.Error.NoInput", (String[])new String[0]));
                    break block11;
                }
                retVal.setError(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.Error.NoConnection", (String[])new String[0]));
            }
            catch (HopException e) {
                retVal.setError(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]));
            }
        }
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        String realTableName = variables.resolve(this.tableName);
        String realSchemaName = variables.resolve(this.schemaName);
        DatabaseMeta databaseMeta = this.getParentTransformMeta().getParentPipelineMeta().findDatabase(this.connection, variables);
        if (databaseMeta == null) throw new HopException(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, variables, databaseMeta);
        try {
            db.connect();
            if (Utils.isEmpty((CharSequence)realTableName)) throw new HopException(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.Exception.TableNotSpecified", (String[])new String[0]));
            if (db.checkTableExists(realSchemaName, realTableName)) {
                IRowMeta iRowMeta = db.getTableFieldsMeta(realSchemaName, realTableName);
                return iRowMeta;
            }
            try {
                throw new HopException(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.file.fileName), (IVariables)variables);
            if (fileObject.exists()) {
                this.file.fileName = iResourceNaming.nameResource(fileObject, variables, true);
                return this.file.fileName;
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    @Generated
    public String getConnection() {
        return this.connection;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public boolean isTruncateTable() {
        return this.truncateTable;
    }

    @Generated
    public boolean isAddToResult() {
        return this.addToResult;
    }

    @Generated
    public boolean isCreateTable() {
        return this.createTable;
    }

    @Generated
    public SqlFile getFile() {
        return this.file;
    }

    @Generated
    public String getEncoding() {
        return this.encoding;
    }

    @Generated
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Generated
    public boolean isStartNewLine() {
        return this.startNewLine;
    }

    @Generated
    public void setConnection(String connection) {
        this.connection = connection;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setTruncateTable(boolean truncateTable) {
        this.truncateTable = truncateTable;
    }

    @Generated
    public void setAddToResult(boolean addToResult) {
        this.addToResult = addToResult;
    }

    @Generated
    public void setCreateTable(boolean createTable) {
        this.createTable = createTable;
    }

    @Generated
    public void setFile(SqlFile file) {
        this.file = file;
    }

    @Generated
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Generated
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Generated
    public void setStartNewLine(boolean startNewLine) {
        this.startNewLine = startNewLine;
    }

    public static final class SqlFile {
        @HopMetadataProperty(key="name")
        private String fileName;
        @HopMetadataProperty(key="create_parent_folder")
        private boolean createParentFolder;
        @HopMetadataProperty(key="DoNotOpenNewFileInit")
        private boolean doNotOpenNewFileInit;
        @HopMetadataProperty(key="extension")
        private String extension;
        @HopMetadataProperty(key="splitevery")
        private int splitEvery;
        @HopMetadataProperty(key="append")
        private boolean fileAppended;
        @HopMetadataProperty(key="split")
        private boolean transformNrInFilename;
        @HopMetadataProperty(key="haspartno")
        private boolean partNrInFilename;
        @HopMetadataProperty(key="add_date")
        private boolean dateInFilename;
        @HopMetadataProperty(key="add_time")
        private boolean timeInFilename;

        @Generated
        public String getFileName() {
            return this.fileName;
        }

        @Generated
        public boolean isCreateParentFolder() {
            return this.createParentFolder;
        }

        @Generated
        public boolean isDoNotOpenNewFileInit() {
            return this.doNotOpenNewFileInit;
        }

        @Generated
        public String getExtension() {
            return this.extension;
        }

        @Generated
        public int getSplitEvery() {
            return this.splitEvery;
        }

        @Generated
        public boolean isFileAppended() {
            return this.fileAppended;
        }

        @Generated
        public boolean isTransformNrInFilename() {
            return this.transformNrInFilename;
        }

        @Generated
        public boolean isPartNrInFilename() {
            return this.partNrInFilename;
        }

        @Generated
        public boolean isDateInFilename() {
            return this.dateInFilename;
        }

        @Generated
        public boolean isTimeInFilename() {
            return this.timeInFilename;
        }

        @Generated
        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Generated
        public void setCreateParentFolder(boolean createParentFolder) {
            this.createParentFolder = createParentFolder;
        }

        @Generated
        public void setDoNotOpenNewFileInit(boolean doNotOpenNewFileInit) {
            this.doNotOpenNewFileInit = doNotOpenNewFileInit;
        }

        @Generated
        public void setExtension(String extension) {
            this.extension = extension;
        }

        @Generated
        public void setSplitEvery(int splitEvery) {
            this.splitEvery = splitEvery;
        }

        @Generated
        public void setFileAppended(boolean fileAppended) {
            this.fileAppended = fileAppended;
        }

        @Generated
        public void setTransformNrInFilename(boolean transformNrInFilename) {
            this.transformNrInFilename = transformNrInFilename;
        }

        @Generated
        public void setPartNrInFilename(boolean partNrInFilename) {
            this.partNrInFilename = partNrInFilename;
        }

        @Generated
        public void setDateInFilename(boolean dateInFilename) {
            this.dateInFilename = dateInFilename;
        }

        @Generated
        public void setTimeInFilename(boolean timeInFilename) {
            this.timeInFilename = timeInFilename;
        }
    }
}

