/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.io.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.source.FlinkSourceSplit;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyFlinkSourceSplitEnumerator<@UnknownKeyFor T>
implements SplitEnumerator<FlinkSourceSplit<T>, Map<Integer, List<FlinkSourceSplit<T>>>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(LazyFlinkSourceSplitEnumerator.class);
    private final @UnknownKeyFor @NonNull @Initialized SplitEnumeratorContext<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>> context;
    private final @UnknownKeyFor @NonNull @Initialized Source<T> beamSource;
    private final @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;
    private final @UnknownKeyFor @NonNull @Initialized int numSplits;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>> pendingSplits;
    private @UnknownKeyFor @NonNull @Initialized boolean splitsInitialized;

    public LazyFlinkSourceSplitEnumerator(@UnknownKeyFor @NonNull @Initialized SplitEnumeratorContext<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>> context, @UnknownKeyFor @NonNull @Initialized Source<T> beamSource, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized int numSplits, @UnknownKeyFor @NonNull @Initialized boolean splitInitialized) {
        this.context = context;
        this.beamSource = beamSource;
        this.pipelineOptions = pipelineOptions;
        this.numSplits = numSplits;
        this.pendingSplits = new ArrayList<FlinkSourceSplit<T>>(numSplits);
        this.splitsInitialized = splitInitialized;
    }

    public void start() {
        if (!this.splitsInitialized) {
            this.initializeSplits();
        }
    }

    public void initializeSplits() {
        this.context.callAsync(() -> {
            try {
                LOG.info("Starting source {}", this.beamSource);
                List<Source<T>> beamSplitSourceList = this.splitBeamSource();
                int i = 0;
                for (Source<T> beamSplitSource : beamSplitSourceList) {
                    this.pendingSplits.add(new FlinkSourceSplit<T>(i, beamSplitSource));
                    ++i;
                }
                return this.pendingSplits;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (sourceSplits, error) -> {
            if (error != null) {
                this.pendingSplits.addAll((Collection<FlinkSourceSplit<T>>)sourceSplits);
                throw new RuntimeException("Failed to start source enumerator.", (Throwable)error);
            }
        });
    }

    public void handleSplitRequest(@UnknownKeyFor @NonNull @Initialized int subtask, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String hostname) {
        if (!this.context.registeredReaders().containsKey(subtask)) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            String hostInfo = hostname == null ? "(no host locality info)" : "(on host '" + hostname + "')";
            LOG.info("Subtask {} {} is requesting a file source split", (Object)subtask, (Object)hostInfo);
        }
        if (!this.pendingSplits.isEmpty()) {
            FlinkSourceSplit<T> split = this.pendingSplits.remove(this.pendingSplits.size() - 1);
            this.context.assignSplit(split, subtask);
            LOG.info("Assigned split to subtask {} : {}", (Object)subtask, split);
        } else {
            this.context.signalNoMoreSplits(subtask);
            LOG.info("No more splits available for subtask {}", (Object)subtask);
        }
    }

    public void addSplitsBack(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>> splits, @UnknownKeyFor @NonNull @Initialized int subtaskId) {
        LOG.info("Adding splits {} back from subtask {}", splits, (Object)subtaskId);
        this.pendingSplits.addAll(splits);
    }

    public void addReader(@UnknownKeyFor @NonNull @Initialized int subtaskId) {
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>>> snapshotState(@UnknownKeyFor @NonNull @Initialized long checkpointId) throws @UnknownKeyFor @NonNull @Initialized Exception {
        LOG.info("Taking snapshot for checkpoint {}", (Object)checkpointId);
        return this.snapshotState();
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>>> snapshotState() throws @UnknownKeyFor @NonNull @Initialized Exception {
        HashMap<Integer, List<FlinkSourceSplit<T>>> state = new HashMap<Integer, List<FlinkSourceSplit<T>>>(1);
        state.put(1, this.pendingSplits);
        return state;
    }

    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    private @UnknownKeyFor @NonNull @Initialized long getDesiredSizeBytes(@UnknownKeyFor @NonNull @Initialized int numSplits, @UnknownKeyFor @NonNull @Initialized BoundedSource<T> boundedSource) throws @UnknownKeyFor @NonNull @Initialized Exception {
        long totalSize = boundedSource.getEstimatedSizeBytes(this.pipelineOptions);
        long defaultSplitSize = totalSize / (long)numSplits;
        long maxSplitSize = 0L;
        if (this.pipelineOptions != null) {
            maxSplitSize = ((FlinkPipelineOptions)this.pipelineOptions.as(FlinkPipelineOptions.class)).getFileInputSplitMaxSizeMB();
        }
        if (this.beamSource instanceof FileBasedSource && maxSplitSize > 0L) {
            return Math.min(defaultSplitSize, maxSplitSize * 1024L * 1024L);
        }
        return defaultSplitSize;
    }

    private @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Source<T>> splitBeamSource() throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.beamSource instanceof BoundedSource) {
            BoundedSource boundedSource = (BoundedSource)this.beamSource;
            long desiredSizeBytes = this.getDesiredSizeBytes(this.numSplits, boundedSource);
            List splits = ((BoundedSource)this.beamSource).split(desiredSizeBytes, this.pipelineOptions);
            LOG.info("Split bounded source {} in {} splits", this.beamSource, (Object)splits.size());
            return splits;
        }
        if (this.beamSource instanceof UnboundedSource) {
            List splits = ((UnboundedSource)this.beamSource).split(this.numSplits, this.pipelineOptions);
            LOG.info("Split source {} to {} splits", this.beamSource, (Object)splits);
            return splits;
        }
        throw new IllegalStateException("Unknown source type " + this.beamSource.getClass());
    }
}

