/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class PaperCreateResult {
    @Nonnull
    protected final String url;
    @Nonnull
    protected final String resultPath;
    @Nonnull
    protected final String fileId;
    protected final long paperRevision;

    public PaperCreateResult(@Nonnull String url, @Nonnull String resultPath, @Nonnull String fileId, long paperRevision) {
        if (url == null) {
            throw new IllegalArgumentException("Required value for 'url' is null");
        }
        this.url = url;
        if (resultPath == null) {
            throw new IllegalArgumentException("Required value for 'resultPath' is null");
        }
        this.resultPath = resultPath;
        if (fileId == null) {
            throw new IllegalArgumentException("Required value for 'fileId' is null");
        }
        if (fileId.length() < 4) {
            throw new IllegalArgumentException("String 'fileId' is shorter than 4");
        }
        if (!Pattern.matches("id:.+", fileId)) {
            throw new IllegalArgumentException("String 'fileId' does not match pattern");
        }
        this.fileId = fileId;
        this.paperRevision = paperRevision;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    @Nonnull
    public String getResultPath() {
        return this.resultPath;
    }

    @Nonnull
    public String getFileId() {
        return this.fileId;
    }

    public long getPaperRevision() {
        return this.paperRevision;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.url, this.resultPath, this.fileId, this.paperRevision});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            PaperCreateResult other = (PaperCreateResult)obj;
            return !(this.url != other.url && !this.url.equals(other.url) || this.resultPath != other.resultPath && !this.resultPath.equals(other.resultPath) || this.fileId != other.fileId && !this.fileId.equals(other.fileId) || this.paperRevision != other.paperRevision);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<PaperCreateResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PaperCreateResult value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("url");
            StoneSerializers.string().serialize(value.url, g);
            g.writeFieldName("result_path");
            StoneSerializers.string().serialize(value.resultPath, g);
            g.writeFieldName("file_id");
            StoneSerializers.string().serialize(value.fileId, g);
            g.writeFieldName("paper_revision");
            StoneSerializers.int64().serialize((Long)value.paperRevision, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public PaperCreateResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_paperRevision;
            String f_fileId;
            String f_resultPath;
            String f_url;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_url = null;
                f_resultPath = null;
                f_fileId = null;
                f_paperRevision = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("url".equals(field)) {
                        f_url = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("result_path".equals(field)) {
                        f_resultPath = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("file_id".equals(field)) {
                        f_fileId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("paper_revision".equals(field)) {
                        f_paperRevision = StoneSerializers.int64().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_url == null) {
                    throw new JsonParseException(p, "Required field \"url\" missing.");
                }
                if (f_resultPath == null) {
                    throw new JsonParseException(p, "Required field \"result_path\" missing.");
                }
                if (f_fileId == null) {
                    throw new JsonParseException(p, "Required field \"file_id\" missing.");
                }
                if (f_paperRevision == null) {
                    throw new JsonParseException(p, "Required field \"paper_revision\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            PaperCreateResult value = new PaperCreateResult(f_url, f_resultPath, f_fileId, f_paperRevision);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

