/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.drools.template.DataProvider;
import org.drools.template.parser.DataListener;
import org.drools.template.parser.DefaultTemplateContainer;
import org.drools.template.parser.TemplateDataListener;

public class DataProviderCompiler {
    public String compile(DataProvider dataProvider, String template) {
        InputStream templateStream = this.getClass().getResourceAsStream(template);
        return this.compile(dataProvider, templateStream);
    }

    public String compile(DataProvider dataProvider, InputStream templateStream) {
        return this.compile(dataProvider, templateStream, true);
    }

    public String compile(DataProvider dataProvider, TemplateDataListener listener) {
        return this.compile(dataProvider, listener, true);
    }

    public String compile(DataProvider dataProvider, String template, boolean replaceOptionals) {
        InputStream templateStream = this.getClass().getResourceAsStream(template);
        return this.compile(dataProvider, templateStream);
    }

    public String compile(DataProvider dataProvider, InputStream templateStream, boolean replaceOptionals) {
        DefaultTemplateContainer tc = new DefaultTemplateContainer(templateStream, replaceOptionals);
        this.closeStream(templateStream);
        return this.compile(dataProvider, new TemplateDataListener(tc));
    }

    public String compile(DataProvider dataProvider, TemplateDataListener listener, boolean replaceOptionals) {
        ArrayList<DataListener> listeners = new ArrayList<DataListener>();
        listeners.add(listener);
        this.processData(dataProvider, listeners);
        return listener.renderDRL();
    }

    private void processData(DataProvider dataProvider, List<DataListener> listeners) {
        int i = 0;
        while (dataProvider.hasNext()) {
            String[] row = dataProvider.next();
            this.newRow(listeners, i, row.length);
            for (int cellNum = 0; cellNum < row.length; ++cellNum) {
                String cell = row[cellNum];
                this.newCell(listeners, i, cellNum, cell, -1);
            }
            ++i;
        }
        this.finishData(listeners);
    }

    private void finishData(List<DataListener> listeners) {
        for (DataListener listener : listeners) {
            listener.finishSheet();
        }
    }

    private void newRow(List<DataListener> listeners, int row, int cols) {
        for (DataListener listener : listeners) {
            listener.newRow(row, cols);
        }
    }

    public void newCell(List<DataListener> listeners, int row, int column, String value, int mergedColStart) {
        for (DataListener listener : listeners) {
            listener.newCell(row, column, value, mergedColStart);
        }
    }

    protected void closeStream(InputStream stream) {
        try {
            stream.close();
        }
        catch (Exception e) {
            System.err.print("WARNING: Wasn't able to correctly close stream for rule template. " + e.getMessage());
        }
    }
}

