/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.pipeline.context;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.plugin.IGuiRefresher;
import org.apache.hop.core.gui.plugin.action.GuiAction;
import org.apache.hop.core.gui.plugin.action.GuiActionLambdaBuilder;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.context.BaseGuiContextHandler;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;

public class HopGuiPipelineTransformContext
extends BaseGuiContextHandler
implements IGuiContextHandler {
    public static final Class<?> PKG = HopGuiPipelineTransformContext.class;
    public static final String CONTEXT_ID = "HopGuiPipelineTransformContext";
    private PipelineMeta pipelineMeta;
    private TransformMeta transformMeta;
    private HopGuiPipelineGraph pipelineGraph;
    private Point click;
    private GuiActionLambdaBuilder<HopGuiPipelineTransformContext> lambdaBuilder;

    public HopGuiPipelineTransformContext(PipelineMeta pipelineMeta, TransformMeta transformMeta, HopGuiPipelineGraph pipelineGraph, Point click) {
        this.pipelineMeta = pipelineMeta;
        this.transformMeta = transformMeta;
        this.pipelineGraph = pipelineGraph;
        this.click = click;
        this.lambdaBuilder = new GuiActionLambdaBuilder();
    }

    @Override
    public String getContextId() {
        return CONTEXT_ID;
    }

    @Override
    public List<GuiAction> getSupportedActions() {
        ArrayList<GuiAction> actions = new ArrayList<GuiAction>();
        ITransformMeta iTransformMeta = this.transformMeta.getTransform();
        String[] objectDescriptions = iTransformMeta.getReferencedObjectDescriptions();
        for (int i = 0; objectDescriptions != null && i < objectDescriptions.length; ++i) {
            String objectDescription = objectDescriptions[i];
            if (!iTransformMeta.isReferencedObjectEnabled()[i]) continue;
            int index = i;
            GuiAction openReferencedAction = new GuiAction("transform-open-referenced-" + objectDescription, GuiActionType.Info, BaseMessages.getString(PKG, (String)"HopGuiPipelineTransformContext.OpenReferencedAction.Name", (String[])new String[]{objectDescription}), BaseMessages.getString(PKG, (String)"HopGuiPipelineTransformContext.OpenReferencedAction.Tooltip", (String[])new String[0]), "ui/images/open.svg", (shiftAction, controlAction, t) -> HopGuiPipelineTransformContext.openReferencedObject(this.pipelineMeta, this.pipelineGraph.getVariables(), iTransformMeta, objectDescription, index));
            openReferencedAction.setCategory("Basic");
            openReferencedAction.setCategoryOrder("1");
            actions.add(openReferencedAction);
        }
        List<GuiAction> pluginActions = this.getPluginActions(true);
        if (pluginActions != null) {
            for (GuiAction pluginAction : pluginActions) {
                actions.add(this.lambdaBuilder.createLambda(pluginAction, (Object)this, (IGuiRefresher)this.pipelineGraph));
            }
        }
        return actions;
    }

    public static void openReferencedObject(PipelineMeta pipelineMeta, IVariables variables, ITransformMeta iTransformMeta, String objectDescription, int index) {
        HopGui hopGui = HopGui.getInstance();
        try {
            IHasFilename hasFilename = iTransformMeta.loadReferencedObject(index, pipelineMeta.getMetadataProvider(), variables);
            if (hasFilename != null) {
                String filename = variables.resolve(hasFilename.getFilename());
                ExplorerPerspective perspective = HopGui.getExplorerPerspective();
                IHopFileTypeHandler fileTypeHandler = perspective.findFileTypeHandlerByFilename(filename);
                if (fileTypeHandler != null) {
                    perspective.setActiveFileTypeHandler(fileTypeHandler);
                } else {
                    hopGui.fileDelegate.fileOpen(filename);
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), "Error", "Error opening referenced object '" + objectDescription + "'", e);
        }
    }

    public PipelineMeta getPipelineMeta() {
        return this.pipelineMeta;
    }

    public void setPipelineMeta(PipelineMeta pipelineMeta) {
        this.pipelineMeta = pipelineMeta;
    }

    public TransformMeta getTransformMeta() {
        return this.transformMeta;
    }

    public void setTransformMeta(TransformMeta transformMeta) {
        this.transformMeta = transformMeta;
    }

    public HopGuiPipelineGraph getPipelineGraph() {
        return this.pipelineGraph;
    }

    public void setPipelineGraph(HopGuiPipelineGraph pipelineGraph) {
        this.pipelineGraph = pipelineGraph;
    }

    public Point getClick() {
        return this.click;
    }

    public void setClick(Point click) {
        this.click = click;
    }
}

