/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mongodbinput;

import com.mongodb.ServerAddress;
import com.mongodb.client.AggregateIterable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mongo.MongoDbException;
import org.apache.hop.mongo.metadata.MongoDbConnection;
import org.apache.hop.mongo.wrapper.field.MongodbInputDiscoverFieldsImpl;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mongodbinput.MongoDbInputData;
import org.apache.hop.pipeline.transforms.mongodbinput.MongoDbInputMeta;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDbInput
extends BaseTransform<MongoDbInputMeta, MongoDbInputData> {
    private static final Class<?> PKG = MongoDbInputMeta.class;
    private boolean serverDetermined;
    private Object[] currentInputRowDrivingQuery = null;

    public MongoDbInput(TransformMeta transformMeta, MongoDbInputMeta meta, MongoDbInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        try {
            boolean hasNext;
            if (((MongoDbInputMeta)this.meta).isExecuteForEachIncomingRow() && this.currentInputRowDrivingQuery == null) {
                this.currentInputRowDrivingQuery = this.getRow();
                if (this.currentInputRowDrivingQuery == null) {
                    this.setOutputDone();
                    return false;
                }
                if (!this.first) {
                    this.initQuery();
                }
            }
            if (this.first) {
                ((MongoDbInputData)this.data).outputRowMeta = new RowMeta();
                ((MongoDbInputMeta)this.meta).getFields(((MongoDbInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                this.initQuery();
                this.first = false;
                ((MongoDbInputData)this.data).init();
            }
            boolean bl = (((MongoDbInputMeta)this.meta).isAggPipeline() ? ((MongoDbInputData)this.data).pipelineResult.hasNext() : ((MongoDbInputData)this.data).cursor.hasNext()) && !this.isStopped() ? true : (hasNext = false);
            if (hasNext) {
                ServerAddress s;
                Document nextDoc = null;
                Object[] row = null;
                nextDoc = ((MongoDbInputMeta)this.meta).isAggPipeline() ? ((MongoDbInputData)this.data).pipelineResult.next() : ((MongoDbInputData)this.data).cursor.next();
                if (!((MongoDbInputMeta)this.meta).isAggPipeline() && !this.serverDetermined && (s = ((MongoDbInputData)this.data).cursor.getServerAddress()) != null) {
                    this.serverDetermined = true;
                    if (this.isBasic()) {
                        this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbInput.Message.QueryPulledDataFrom", (String[])new String[]{s.toString()}));
                    }
                }
                if (((MongoDbInputMeta)this.meta).isOutputJson() || ((MongoDbInputMeta)this.meta).getFields() == null || ((MongoDbInputMeta)this.meta).getFields().isEmpty()) {
                    String json = nextDoc.toJson();
                    row = RowDataUtil.allocateRowData((int)((MongoDbInputData)this.data).outputRowMeta.size());
                    int index = 0;
                    row[index++] = json;
                    this.putRow(((MongoDbInputData)this.data).outputRowMeta, row);
                } else {
                    Object[][] outputRows;
                    for (Object[] outputRow : outputRows = ((MongoDbInputData)this.data).mongoDocumentToHop(nextDoc, (IVariables)this)) {
                        this.putRow(((MongoDbInputData)this.data).outputRowMeta, outputRow);
                    }
                }
            } else {
                if (!((MongoDbInputMeta)this.meta).isExecuteForEachIncomingRow()) {
                    this.setOutputDone();
                    return false;
                }
                this.currentInputRowDrivingQuery = null;
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof HopException) {
                HopException hopException = (HopException)((Object)e);
                throw hopException;
            }
            throw new HopException((Throwable)e);
        }
    }

    protected void initQuery() throws HopException, MongoDbException {
        if (((MongoDbInputData)this.data).cursor != null) {
            ((MongoDbInputData)this.data).cursor.close();
        }
        if (this.isDetailed()) {
            this.serverDetermined = false;
        }
        String query = this.resolve(((MongoDbInputMeta)this.meta).getJsonQuery());
        String fields = this.resolve(((MongoDbInputMeta)this.meta).getJsonField());
        if (StringUtils.isEmpty((String)query) && StringUtils.isEmpty((String)fields)) {
            if (((MongoDbInputMeta)this.meta).isAggPipeline()) {
                throw new HopException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.EmptyAggregationPipeline", (String[])new String[0]));
            }
            ((MongoDbInputData)this.data).cursor = ((MongoDbInputData)this.data).collection.find();
        } else if (((MongoDbInputMeta)this.meta).isAggPipeline()) {
            if (StringUtils.isEmpty((String)query)) {
                throw new HopException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.EmptyAggregationPipeline", (String[])new String[0]));
            }
            if (((MongoDbInputMeta)this.meta).isExecuteForEachIncomingRow() && this.currentInputRowDrivingQuery != null) {
                query = this.resolve(query, this.getInputRowMeta(), this.currentInputRowDrivingQuery);
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"MongoDbInput.Message.QueryPulledDataFrom", (String[])new String[]{query}));
            }
            List<Document> pipeline = MongodbInputDiscoverFieldsImpl.jsonPipelineToDocumentList(query);
            Document firstP = pipeline.get(0);
            Document[] remainder = null;
            if (pipeline.size() > 1) {
                remainder = new Document[pipeline.size() - 1];
                for (int i = 1; i < pipeline.size(); ++i) {
                    remainder[i - 1] = pipeline.get(i);
                }
            } else {
                remainder = new Document[]{};
            }
            AggregateIterable<Document> aggregateIterable = ((MongoDbInputData)this.data).collection.aggregate((Bson)firstP, (Bson[])remainder);
            ((MongoDbInputData)this.data).pipelineResult = aggregateIterable.iterator();
        } else {
            if (((MongoDbInputMeta)this.meta).isExecuteForEachIncomingRow() && this.currentInputRowDrivingQuery != null) {
                query = this.resolve(query, this.getInputRowMeta(), this.currentInputRowDrivingQuery);
                fields = this.resolve(fields, this.getInputRowMeta(), this.currentInputRowDrivingQuery);
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"MongoDbInput.Message.ExecutingQuery", (String[])new String[]{query}));
            }
            Document queryDoc = Document.parse((String)(StringUtils.isEmpty((String)query) ? "{}" : query));
            Document fieldsDoc = StringUtils.isEmpty((String)fields) ? null : Document.parse((String)fields);
            ((MongoDbInputData)this.data).cursor = ((MongoDbInputData)this.data).collection.find((Bson)queryDoc, (Bson)fieldsDoc);
        }
    }

    public boolean init() {
        if (super.init()) {
            String connectionName = this.resolve(((MongoDbInputMeta)this.meta).getConnectionName());
            try {
                try {
                    ((MongoDbInputData)this.data).connection = (MongoDbConnection)this.metadataProvider.getSerializer(MongoDbConnection.class).load(connectionName);
                }
                catch (Exception e) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.ErrorLoadingMongoDbConnection", (String[])new String[]{connectionName}));
                }
                if (((MongoDbInputData)this.data).connection == null) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.MongoDbConnection.NotFound", (String[])new String[]{connectionName}));
                }
                String databaseName = this.resolve(((MongoDbInputData)this.data).connection.getDbName());
                if (StringUtils.isEmpty((String)databaseName)) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.NoDBSpecified", (String[])new String[0]));
                }
                String collection = this.resolve(((MongoDbInputMeta)this.meta).getCollection());
                if (StringUtils.isEmpty((String)collection)) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.NoCollectionSpecified", (String[])new String[0]));
                }
                if (!StringUtils.isEmpty((String)((MongoDbInputData)this.data).connection.getAuthenticationUser())) {
                    String authInfo = BaseMessages.getString(PKG, (String)"MongoDbInput.Message.NormalAuthentication", (String[])new String[]{this.resolve(((MongoDbInputData)this.data).connection.getAuthenticationUser())});
                    this.logBasic(authInfo);
                }
                ((MongoDbInputData)this.data).clientWrapper = ((MongoDbInputData)this.data).connection.createWrapper((IVariables)this, this.getLogChannel());
                ((MongoDbInputData)this.data).collection = ((MongoDbInputData)this.data).clientWrapper.getCollection(databaseName, collection);
                if (!((MongoDbInputMeta)this.meta).isOutputJson()) {
                    ((MongoDbInputData)this.data).setMongoFields(((MongoDbInputMeta)this.meta).getFields());
                }
                return true;
            }
            catch (Exception e) {
                String hostname = ((MongoDbInputData)this.data).connection != null ? ((MongoDbInputData)this.data).connection.getHostname() : "unknown";
                String port = ((MongoDbInputData)this.data).connection != null ? ((MongoDbInputData)this.data).connection.getPort() : "unknown";
                String dbName = ((MongoDbInputData)this.data).connection != null ? ((MongoDbInputData)this.data).connection.getDbName() : "unknown";
                this.logError(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorConnectingToMongoDb.Exception", (String[])new String[]{hostname, port, dbName, ((MongoDbInputMeta)this.meta).getCollection()}), e);
                return false;
            }
        }
        return false;
    }

    public void dispose() {
        if (((MongoDbInputData)this.data).cursor != null) {
            try {
                ((MongoDbInputData)this.data).cursor.close();
            }
            catch (MongoDbException e) {
                this.logError(e.getMessage());
            }
        }
        if (((MongoDbInputData)this.data).clientWrapper != null) {
            try {
                ((MongoDbInputData)this.data).clientWrapper.dispose();
            }
            catch (MongoDbException e) {
                this.logError(e.getMessage());
            }
        }
        super.dispose();
    }
}

