/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams;

import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.protobuf.ByteString;
import com.google.protobuf.TextFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class ByteStringRangeHelper {
    private static @UnknownKeyFor @NonNull @Initialized int compareStartKey(@UnknownKeyFor @NonNull @Initialized ByteString s1, @UnknownKeyFor @NonNull @Initialized ByteString s2) {
        return ByteString.unsignedLexicographicalComparator().compare(s1, s2);
    }

    private static @UnknownKeyFor @NonNull @Initialized int compareEndKey(@UnknownKeyFor @NonNull @Initialized ByteString e1, @UnknownKeyFor @NonNull @Initialized ByteString e2) {
        if (e1.isEmpty() && !e2.isEmpty()) {
            return 1;
        }
        if (e2.isEmpty() && !e1.isEmpty()) {
            return -1;
        }
        return ByteString.unsignedLexicographicalComparator().compare(e1, e2);
    }

    private static @UnknownKeyFor @NonNull @Initialized int compareStartEndKey(@UnknownKeyFor @NonNull @Initialized ByteString start, @UnknownKeyFor @NonNull @Initialized ByteString end) {
        if (end.isEmpty()) {
            return -1;
        }
        return ByteString.unsignedLexicographicalComparator().compare(start, end);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean coverSameKeySpace(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> parentPartitions, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange childPartition) {
        if (parentPartitions.isEmpty()) {
            return false;
        }
        parentPartitions.sort(new PartitionComparator());
        if (!((ByteString)parentPartitions.get(0).getStart()).equals(childPartition.getStart())) {
            return false;
        }
        if (!((ByteString)parentPartitions.get(parentPartitions.size() - 1).getEnd()).equals(childPartition.getEnd())) {
            return false;
        }
        return ByteStringRangeHelper.isContinuous(parentPartitions);
    }

    public static @UnknownKeyFor @NonNull @Initialized String partitionsToString(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> partitions) {
        return partitions.stream().map(ByteStringRangeHelper::formatByteStringRange).collect(Collectors.joining(", ", "{", "}"));
    }

    public static @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> getMissingPartitionsFrom(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> partitions, @UnknownKeyFor @NonNull @Initialized ByteString start, @UnknownKeyFor @NonNull @Initialized ByteString end) {
        if (partitions.isEmpty()) {
            return Collections.singletonList(Range.ByteStringRange.create((ByteString)start, (ByteString)end));
        }
        ArrayList<Range.ByteStringRange> missingPartitions = new ArrayList<Range.ByteStringRange>();
        partitions.sort(new PartitionComparator());
        if (ByteStringRangeHelper.compareStartKey(start, (ByteString)partitions.get(0).getStart()) < 0) {
            missingPartitions.add(Range.ByteStringRange.create((ByteString)start, (ByteString)((ByteString)partitions.get(0).getStart())));
        }
        ByteString currEnd = (ByteString)partitions.get(0).getEnd();
        if (ByteStringRangeHelper.compareStartKey(start, (ByteString)partitions.get(0).getEnd()) > 0) {
            currEnd = start;
        }
        for (int i = 1; i < partitions.size(); ++i) {
            if (ByteStringRangeHelper.compareStartEndKey((ByteString)partitions.get(i).getStart(), currEnd) > 0) {
                missingPartitions.add(Range.ByteStringRange.create((ByteString)currEnd, (ByteString)((ByteString)partitions.get(i).getStart())));
            }
            if (ByteStringRangeHelper.compareEndKey(currEnd, (ByteString)partitions.get(i).getEnd()) < 0) {
                currEnd = (ByteString)partitions.get(i).getEnd();
            }
            if (ByteStringRangeHelper.compareStartKey(start, currEnd) > 0) {
                currEnd = start;
            }
            if (ByteStringRangeHelper.compareEndKey(currEnd, end) > 0) break;
        }
        if (ByteStringRangeHelper.compareEndKey(currEnd, end) < 0) {
            missingPartitions.add(Range.ByteStringRange.create((ByteString)currEnd, (ByteString)end));
        }
        return missingPartitions;
    }

    public static @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> getMissingPartitionsFromEntireKeySpace(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> partitions) {
        return ByteStringRangeHelper.getMissingPartitionsFrom(partitions, ByteString.EMPTY, ByteString.EMPTY);
    }

    public static @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> getOverlappingPartitions(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> partitions) {
        if (partitions.isEmpty() || partitions.size() == 1) {
            return Collections.emptyList();
        }
        ArrayList<Range.ByteStringRange> overlappingPartitions = new ArrayList<Range.ByteStringRange>();
        partitions.sort(new PartitionComparator());
        ByteString prevEnd = (ByteString)partitions.get(0).getEnd();
        for (int i = 1; i < partitions.size(); ++i) {
            if (ByteStringRangeHelper.compareStartEndKey((ByteString)partitions.get(i).getStart(), prevEnd) < 0) {
                overlappingPartitions.add(Range.ByteStringRange.create((ByteString)((ByteString)partitions.get(i).getStart()), (ByteString)prevEnd));
            }
            prevEnd = (ByteString)partitions.get(i).getEnd();
        }
        return overlappingPartitions;
    }

    public static @UnknownKeyFor @NonNull @Initialized String formatByteStringRange(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition) {
        return "['" + TextFormat.escapeBytes((ByteString)((ByteString)partition.getStart())) + "','" + TextFormat.escapeBytes((ByteString)((ByteString)partition.getEnd())) + "')";
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isContinuous(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> sortedParentPartitions) {
        for (int i = 1; i < sortedParentPartitions.size(); ++i) {
            ByteString prevEndKey = (ByteString)sortedParentPartitions.get(i - 1).getEnd();
            if (((ByteString)sortedParentPartitions.get(i).getStart()).equals((Object)prevEndKey)) continue;
            return false;
        }
        return true;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean doPartitionsOverlap(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange first, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange second) {
        if (ByteString.unsignedLexicographicalComparator().compare((ByteString)second.getStart(), (ByteString)first.getEnd()) >= 0 && !((ByteString)first.getEnd()).isEmpty()) {
            return false;
        }
        return ByteString.unsignedLexicographicalComparator().compare((ByteString)first.getStart(), (ByteString)second.getEnd()) < 0 || ((ByteString)second.getEnd()).isEmpty();
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isValidPartition(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition) {
        return ByteString.unsignedLexicographicalComparator().compare((ByteString)partition.getStart(), (ByteString)partition.getEnd()) < 0 || ((ByteString)partition.getEnd()).isEmpty();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange getIntersectingPartition(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange p1, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange p2) throws @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
        if (!ByteStringRangeHelper.doPartitionsOverlap(p1, p2)) {
            throw new IllegalArgumentException(String.format("The partitions %s and %s have no overlap", ByteStringRangeHelper.formatByteStringRange(p1), ByteStringRangeHelper.formatByteStringRange(p2)));
        }
        ByteString start = (ByteString)p1.getStart();
        ByteString end = (ByteString)p1.getEnd();
        if (ByteStringRangeHelper.compareStartKey(start, (ByteString)p2.getStart()) < 0) {
            start = (ByteString)p2.getStart();
        }
        if (ByteStringRangeHelper.compareEndKey(end, (ByteString)p2.getEnd()) > 0) {
            end = (ByteString)p2.getEnd();
        }
        return Range.ByteStringRange.create((ByteString)start, (ByteString)end);
    }

    @VisibleForTesting
    static class PartitionComparator
    implements Comparator<Range.ByteStringRange> {
        PartitionComparator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int compare(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange first, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange second) {
            int compareStart = ByteStringRangeHelper.compareStartKey((ByteString)first.getStart(), (ByteString)second.getStart());
            if (compareStart != 0) {
                return compareStart;
            }
            return ByteStringRangeHelper.compareEndKey((ByteString)first.getEnd(), (ByteString)second.getEnd());
        }
    }
}

