/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel.set;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteSetOp;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.util.Commons;

public interface IgniteColocatedSetOp
extends IgniteSetOp {
    @Override
    default public Pair<RelTraitSet, List<RelTraitSet>> passThroughDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        if (TraitUtils.distribution(nodeTraits) == IgniteDistributions.single()) {
            return Pair.of((Object)nodeTraits, Commons.transform(inTraits, t -> t.replace((RelTrait)IgniteDistributions.single())));
        }
        return null;
    }

    @Override
    default public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        boolean haveSingle = false;
        IgniteDistribution hashDistribution = null;
        for (RelTraitSet traits : inputTraits) {
            IgniteDistribution distribution = TraitUtils.distribution(traits);
            if (distribution == IgniteDistributions.single()) {
                if (hashDistribution != null) {
                    return ImmutableList.of();
                }
                haveSingle = true;
                continue;
            }
            if (distribution.getType() == RelDistribution.Type.HASH_DISTRIBUTED) {
                if (haveSingle) {
                    return ImmutableList.of();
                }
                if (hashDistribution == null) {
                    hashDistribution = distribution;
                    continue;
                }
                if (hashDistribution.satisfies((RelTrait)distribution)) continue;
                return ImmutableList.of();
            }
            if (distribution == IgniteDistributions.broadcast()) continue;
            return ImmutableList.of();
        }
        if (!1.$assertionsDisabled && hashDistribution != null && haveSingle) {
            throw new AssertionError();
        }
        if (haveSingle) {
            return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)IgniteDistributions.single()), inputTraits));
        }
        if (hashDistribution != null) {
            IgniteDistribution distribution = hashDistribution;
            return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace(distribution), Commons.transform(inputTraits, t -> t.replace((RelTrait)distribution))));
        }
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)IgniteDistributions.broadcast()), inputTraits));
    }

    @Override
    default public AggregateType aggregateType() {
        return AggregateType.SINGLE;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

