/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.xerces.impl.dv.xs;

import org.apache.jena.ext.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.jena.ext.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.jena.ext.xerces.impl.dv.xs.DateTimeDV;
import org.apache.jena.ext.xerces.impl.dv.xs.SchemaDateTimeException;

public class DateTimeStampDV
extends DateTimeDV {
    private final String invalidDateTimeStampMessage = "%s is an invalid dateTimeStamp data type value. The timezone is missing.";

    @Override
    public Object getActualValue(String content) throws InvalidDatatypeValueException {
        try {
            return this.parse(content);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "dateTimeStamp"});
        }
    }

    @Override
    protected AbstractDateTimeDV.DateTimeData parse(String str) throws SchemaDateTimeException {
        AbstractDateTimeDV.DateTimeData dateTimeData = super.parse(str);
        if (dateTimeData.hasTimeZone()) {
            String errorMessage = String.format("%s is an invalid dateTimeStamp data type value. The timezone is missing.", str);
            throw new SchemaDateTimeException(errorMessage);
        }
        return dateTimeData;
    }
}

