/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.lang;

import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.utils.AssertionUtils;

public class FloatValue
extends Value<Float> {
    public static FloatValue create() {
        return FloatValue.of(Float.valueOf(0.0f));
    }

    public static FloatValue of(Float value) {
        return new FloatValue(value);
    }

    public FloatValue(Float value) {
        super(value);
    }

    public boolean is(float other, float precision) {
        AssertionUtils.assertArg(precision >= 0.0f, "Precision must be non-negative", new Object[0]);
        Float v = (Float)this.get();
        if (v == null) {
            return false;
        }
        return Math.abs(v.floatValue() - other) <= precision;
    }

    public boolean isAny(float precision, float ... values) {
        AssertionUtils.assertArg(precision >= 0.0f, "Precision must be non-negative", new Object[0]);
        AssertionUtils.assertArgNotNull("values", values);
        Float v = (Float)this.get();
        if (v == null) {
            return false;
        }
        for (float value : values) {
            if (!(Math.abs(v.floatValue() - value) <= precision)) continue;
            return true;
        }
        return false;
    }
}

