/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.preprocessorbridge.spi.CompileOnSaveAction;
import org.netbeans.modules.java.source.usages.BuildArtifactMapperImpl;
import org.netbeans.modules.parsing.impl.indexing.IndexerCache;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;

public class COSSynchronizingIndexer
extends CustomIndexer {
    private static final Logger LOG = Logger.getLogger(COSSynchronizingIndexer.class.getName());

    @Override
    protected void index(Iterable<? extends Indexable> files, Context context) {
        URL rootURL = context.getRootURI();
        if (FileUtil.getArchiveFile(rootURL) != null) {
            return;
        }
        if (!BuildArtifactMapperImpl.isUpdateResources(rootURL)) {
            return;
        }
        Set<String> javaMimeTypes = COSSynchronizingIndexer.gatherJavaMimeTypes();
        LinkedList<File> updated = new LinkedList<File>();
        ClassPath srcPath = ClassPath.getClassPath(context.getRoot(), "classpath/source");
        if (srcPath == null) {
            LOG.log(Level.INFO, "No source path for: {0}", FileUtil.getFileDisplayName(context.getRoot()));
            return;
        }
        for (Indexable indexable : files) {
            if (javaMimeTypes.contains(indexable.getMimeType())) continue;
            try {
                URL url = indexable.getURL();
                if (url == null) continue;
                FileObject resource = srcPath.findResource(indexable.getRelativePath());
                if (resource == null) {
                    LOG.log(Level.INFO, "File {0} not on source path {1}, root {2}", new Object[]{indexable.getURL(), srcPath, context.getRoot()});
                    continue;
                }
                if (!FileUtil.isParentOf(context.getRoot(), resource)) continue;
                updated.add(BaseUtilities.toFile(url.toURI()));
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace(ex);
            }
        }
        try {
            File sourceRootFile = BaseUtilities.toFile(context.getRootURI().toURI());
            if (!context.checkForEditorModifications()) {
                BuildArtifactMapperImpl.classCacheUpdated(context.getRootURI(), sourceRootFile, Collections.emptyList(), updated, true, context.isAllFilesIndexing());
            }
        }
        catch (URISyntaxException ex) {
            Exceptions.printStackTrace(ex);
        }
    }

    public static Set<String> gatherJavaMimeTypes() {
        HashSet<String> mimeTypes = new HashSet<String>();
        Collection<IndexerCache.IndexerInfo<CustomIndexerFactory>> indexers = IndexerCache.getCifCache().getIndexersByName("java");
        if (indexers != null) {
            for (IndexerCache.IndexerInfo<CustomIndexerFactory> i : indexers) {
                mimeTypes.addAll(i.getMimeTypes());
            }
        } else {
            LOG.warning("No java indexer found.");
        }
        return mimeTypes;
    }

    public static final class Factory
    extends CustomIndexerFactory {
        @Override
        public CustomIndexer createIndexer() {
            return new COSSynchronizingIndexer();
        }

        @Override
        public boolean supportsEmbeddedIndexers() {
            return true;
        }

        @Override
        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            File target = CompileOnSaveAction.Context.getTarget(context.getRootURI());
            if (target == null) {
                return;
            }
            if (!BuildArtifactMapperImpl.isUpdateClasses(context.getRootURI())) {
                return;
            }
            LinkedList<File> deletedFiles = new LinkedList<File>();
            for (Indexable indexable : deleted) {
                try {
                    deletedFiles.add(BaseUtilities.toFile(indexable.getURL().toURI()));
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace(ex);
                }
            }
            try {
                File sourceRootFile = BaseUtilities.toFile(context.getRootURI().toURI());
                BuildArtifactMapperImpl.classCacheUpdated(context.getRootURI(), sourceRootFile, deletedFiles, Collections.emptyList(), true, context.isAllFilesIndexing());
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace(ex);
            }
        }

        @Override
        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        }

        @Override
        public String getIndexerName() {
            return COSSynchronizingIndexer.class.getName();
        }

        @Override
        public int getIndexVersion() {
            return 1;
        }
    }
}

