/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpt30.lang.model.element.ElementKind;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.AnnotationProcessingQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.indexing.APTUtils;
import org.netbeans.modules.java.source.indexing.TransactionContext;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.BinaryAnalyser;
import org.netbeans.modules.java.source.usages.BinaryName;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.java.source.usages.PersistentIndexTransaction;
import org.netbeans.modules.java.source.usages.QueryUtil;
import org.netbeans.modules.java.source.usages.SourceAnalyzerFactory;
import org.netbeans.modules.parsing.lucene.support.Convertor;
import org.netbeans.modules.parsing.lucene.support.Index;
import org.netbeans.modules.parsing.lucene.support.IndexManager;
import org.netbeans.modules.parsing.lucene.support.Queries;
import org.netbeans.modules.parsing.lucene.support.StoppableConvertor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public final class PersistentClassIndex
extends ClassIndexImpl {
    private final Index index;
    private final URL root;
    private final File cacheRoot;
    private final ClassIndexImpl.Type beforeInitType;
    private final ClassIndexImpl.Type finalType;
    private final IndexPatch indexPath;
    private Set<String> rootPkgCache;
    private volatile FileObject cachedRoot;
    private volatile FileObject[] cachedAptRoots;
    private static final Logger LOGGER = Logger.getLogger(PersistentClassIndex.class.getName());
    private static final String REFERENCES = "refs";

    private PersistentClassIndex(URL root, File cacheRoot, ClassIndexImpl.Type beforeInitType, ClassIndexImpl.Type finalType) throws IOException, IllegalArgumentException {
        assert (root != null);
        this.root = root;
        this.cacheRoot = cacheRoot;
        this.beforeInitType = beforeInitType;
        this.finalType = finalType;
        this.index = IndexManager.createIndex(PersistentClassIndex.getReferencesCacheFolder(cacheRoot), DocumentUtil.createAnalyzer());
        this.indexPath = new IndexPatch();
    }

    @Override
    @NonNull
    public BinaryAnalyser getBinaryAnalyser() {
        TransactionContext txCtx = TransactionContext.get();
        assert (txCtx != null);
        PersistentIndexTransaction pit = txCtx.get(PersistentIndexTransaction.class);
        assert (pit != null);
        ClassIndexImpl.Writer writer = pit.getIndexWriter();
        if (writer == null) {
            writer = new PIWriter();
            pit.setIndexWriter(writer);
        }
        return new BinaryAnalyser(writer, this.cacheRoot);
    }

    @Override
    @NonNull
    public SourceAnalyzerFactory.StorableAnalyzer getSourceAnalyser() {
        TransactionContext txCtx = TransactionContext.get();
        assert (txCtx != null);
        PersistentIndexTransaction pit = txCtx.get(PersistentIndexTransaction.class);
        assert (pit != null);
        ClassIndexImpl.Writer writer = pit.getIndexWriter();
        if (writer == null) {
            writer = new PIWriter();
            pit.setIndexWriter(writer);
        }
        return SourceAnalyzerFactory.createStorableAnalyzer(writer);
    }

    @Override
    public ClassIndexImpl.Type getType() {
        return this.getState() == ClassIndexImpl.State.INITIALIZED ? this.finalType : this.beforeInitType;
    }

    @Override
    public boolean isValid() {
        try {
            return this.index.getStatus(true) != Index.Status.INVALID;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    @NonNull
    public FileObject[] getSourceRoots() {
        if (this.getType() == ClassIndexImpl.Type.SOURCE) {
            FileObject rootFo = this.getRoot();
            if (rootFo == null) {
                return new FileObject[0];
            }
            FileObject[] aptRoots = this.cachedAptRoots;
            if (!PersistentClassIndex.isValid(aptRoots)) {
                FileObject[] fileObjectArray;
                FileObject aptGeneratedRoot;
                URL aptGeneratedURL = PersistentClassIndex.getAPTSourceOutputDirectory(rootFo);
                FileObject fileObject = aptGeneratedRoot = aptGeneratedURL == null ? null : URLMapper.findFileObject(aptGeneratedURL);
                if (aptGeneratedRoot == null) {
                    fileObjectArray = new FileObject[]{};
                } else {
                    FileObject[] fileObjectArray2 = new FileObject[1];
                    fileObjectArray = fileObjectArray2;
                    fileObjectArray2[0] = aptGeneratedRoot;
                }
                this.cachedAptRoots = fileObjectArray;
                aptRoots = fileObjectArray;
            }
            FileObject[] res = new FileObject[1 + aptRoots.length];
            res[0] = rootFo;
            System.arraycopy(aptRoots, 0, res, 1, aptRoots.length);
            return res;
        }
        return SourceForBinaryQuery.findSourceRoots(this.root).getRoots();
    }

    @Override
    public FileObject[] getBinaryRoots() {
        FileObject fo;
        ArrayDeque<FileObject> res = new ArrayDeque<FileObject>();
        if (this.getType() == ClassIndexImpl.Type.BINARY && (fo = URLMapper.findFileObject(this.root)) != null) {
            res.offer(fo);
        }
        return res.toArray(new FileObject[0]);
    }

    @Override
    public String getSourceName(String binaryName) throws IOException, InterruptedException {
        try {
            Query q = DocumentUtil.binaryNameQuery(binaryName);
            HashSet names = new HashSet();
            this.index.query(names, DocumentUtil.sourceNameConvertor(), DocumentUtil.sourceNameFieldSelector(), (AtomicBoolean)cancel.get(), q);
            return names.isEmpty() ? null : (String)names.iterator().next();
        }
        catch (IOException e) {
            return this.handleException(null, e, this.root);
        }
    }

    public static ClassIndexImpl create(URL root, File cacheRoot, ClassIndexImpl.Type beforeInitType, ClassIndexImpl.Type finalType) throws IOException, IllegalArgumentException {
        return new PersistentClassIndex(root, cacheRoot, beforeInitType, finalType);
    }

    @Override
    public <T> void search(@NonNull ElementHandle<?> element, @NonNull Set<? extends ClassIndexImpl.UsageType> usageType, @NonNull Set<? extends ClassIndex.SearchScopeType> scope, @NonNull Convertor<? super Document, T> convertor, @NonNull Set<? super T> result) throws InterruptedException, IOException {
        block6: {
            Parameters.notNull("element", element);
            Parameters.notNull("usageType", usageType);
            Parameters.notNull("scope", scope);
            Parameters.notNull("convertor", convertor);
            Parameters.notNull("result", result);
            Pair ctu = this.indexPath.getPatch(convertor);
            try {
                String binaryName = SourceUtils.getJVMSignature(element)[0];
                ElementKind kind = element.getKind();
                if (kind == ElementKind.PACKAGE) {
                    IndexManager.priorityAccess(() -> {
                        Query q = QueryUtil.scopeFilter(QueryUtil.createPackageUsagesQuery(binaryName, usageType, BooleanClause.Occur.SHOULD), scope);
                        if (q != null) {
                            this.index.query(result, (Convertor)ctu.first(), DocumentUtil.declaredTypesFieldSelector(false, false), (AtomicBoolean)cancel.get(), q);
                            if (ctu.second() != null) {
                                ((Index)ctu.second()).query(result, convertor, DocumentUtil.declaredTypesFieldSelector(false, false), (AtomicBoolean)cancel.get(), q);
                            }
                        }
                        return null;
                    });
                    break block6;
                }
                if (kind.isClass() || kind.isInterface() || kind == ElementKind.OTHER) {
                    if (BinaryAnalyser.OBJECT.equals(binaryName)) {
                        this.getDeclaredElements("", ClassIndex.NameKind.PREFIX, scope, DocumentUtil.declaredTypesFieldSelector(false, false), convertor, result);
                    } else {
                        IndexManager.priorityAccess(() -> {
                            Query usagesQuery = QueryUtil.scopeFilter(QueryUtil.createUsagesQuery(binaryName, usageType, BooleanClause.Occur.SHOULD), scope);
                            if (usagesQuery != null) {
                                this.index.query(result, (Convertor)ctu.first(), DocumentUtil.declaredTypesFieldSelector(false, false), (AtomicBoolean)cancel.get(), usagesQuery);
                                if (ctu.second() != null) {
                                    ((Index)ctu.second()).query(result, convertor, DocumentUtil.declaredTypesFieldSelector(false, false), (AtomicBoolean)cancel.get(), usagesQuery);
                                }
                            }
                            return null;
                        });
                    }
                    break block6;
                }
                throw new IllegalArgumentException(element.toString());
            }
            catch (IOException ioe) {
                this.handleException(null, ioe, this.root);
            }
        }
    }

    @Override
    public <T> void getDeclaredElements(@NonNull String simpleName, @NonNull ClassIndex.NameKind kind, @NonNull Set<? extends ClassIndex.SearchScopeType> scope, @NonNull FieldSelector selector, @NonNull Convertor<? super Document, T> convertor, @NonNull Collection<? super T> result) throws InterruptedException, IOException {
        Pair ctu = this.indexPath.getPatch(convertor);
        try {
            IndexManager.priorityAccess(() -> {
                Query query = QueryUtil.scopeFilter(Queries.createQuery("simpleName", "ciName", simpleName, DocumentUtil.translateQueryKind(kind)), scope);
                if (query != null) {
                    this.index.query(result, (Convertor)ctu.first(), selector, (AtomicBoolean)cancel.get(), query);
                    if (ctu.second() != null) {
                        ((Index)ctu.second()).query(result, convertor, selector, (AtomicBoolean)cancel.get(), query);
                    }
                }
                return null;
            });
        }
        catch (IOException ioe) {
            this.handleException(null, ioe, this.root);
        }
    }

    @Override
    public <T> void getDeclaredElements(String ident, ClassIndex.NameKind kind, Convertor<? super Document, T> convertor, Map<T, Set<String>> result) throws InterruptedException, IOException {
        Pair ctu = this.indexPath.getPatch(convertor);
        try {
            IndexManager.priorityAccess(() -> {
                Query query = Queries.createTermCollectingQuery("fids", "cifids", ident, DocumentUtil.translateQueryKind(kind));
                this.index.queryDocTerms(result, (Convertor)ctu.first(), Term::text, DocumentUtil.declaredTypesFieldSelector(false, false), (AtomicBoolean)cancel.get(), query);
                if (ctu.second() != null) {
                    ((Index)ctu.second()).queryDocTerms(result, convertor, Term::text, DocumentUtil.declaredTypesFieldSelector(false, false), (AtomicBoolean)cancel.get(), query);
                }
                return null;
            });
        }
        catch (IOException ioe) {
            this.handleException(null, ioe, this.root);
        }
    }

    @Override
    public void getPackageNames(String prefix, boolean directOnly, Set<String> result) throws InterruptedException, IOException {
        try {
            IndexManager.priorityAccess(() -> {
                Collection collectInto;
                boolean cacheOp = directOnly && prefix.length() == 0;
                HashSet<String> myPkgs = null;
                if (cacheOp) {
                    PersistentClassIndex persistentClassIndex = this;
                    synchronized (persistentClassIndex) {
                        if (this.rootPkgCache != null) {
                            result.addAll(this.rootPkgCache);
                            return null;
                        }
                    }
                    myPkgs = new HashSet<String>();
                    collectInto = new TeeCollection(myPkgs, result);
                } else {
                    collectInto = result;
                }
                Pair<StoppableConvertor<Term, String>, Term> filter = QueryUtil.createPackageFilter(prefix, directOnly);
                this.index.queryTerms(collectInto, filter.second(), filter.first(), (AtomicBoolean)cancel.get());
                if (cacheOp) {
                    PersistentClassIndex persistentClassIndex = this;
                    synchronized (persistentClassIndex) {
                        if (this.rootPkgCache == null) {
                            assert (myPkgs != null);
                            this.rootPkgCache = myPkgs;
                        }
                    }
                }
                return null;
            });
        }
        catch (IOException ioe) {
            this.handleException(null, ioe, this.root);
        }
    }

    @Override
    public void getReferencesFrequences(@NonNull Map<String, Integer> typeFreq, @NonNull Map<String, Integer> pkgFreq) throws IOException, InterruptedException {
        assert (typeFreq != null);
        assert (pkgFreq != null);
        if (!(this.index instanceof Index.WithTermFrequencies)) {
            throw new IllegalStateException("Index does not support frequencies!");
        }
        try {
            IndexManager.priorityAccess(() -> {
                Term startTerm = DocumentUtil.referencesTerm("", null, true);
                FreqCollector convertor = new FreqCollector(startTerm, typeFreq, pkgFreq);
                ((Index.WithTermFrequencies)this.index).queryTermFrequencies(Collections.emptyList(), startTerm, convertor, (AtomicBoolean)cancel.get());
                return null;
            });
        }
        catch (IOException ioe) {
            this.handleException(null, ioe, this.root);
        }
    }

    @Override
    public void setDirty(URL url) {
        try {
            this.indexPath.setDirtyFile(url);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace(ex);
        }
    }

    public String toString() {
        return "PersistentClassIndex[" + this.root.toExternalForm() + "]";
    }

    @Override
    protected final void close() throws IOException {
        this.index.close();
    }

    private static File getReferencesCacheFolder(File cacheRoot) throws IOException {
        File refRoot = new File(cacheRoot, REFERENCES);
        if (!refRoot.exists()) {
            refRoot.mkdir();
        }
        return refRoot;
    }

    private synchronized void resetPkgCache() {
        this.rootPkgCache = null;
    }

    @CheckForNull
    private FileObject getRoot() {
        FileObject res = this.cachedRoot;
        if (res == null || !res.isValid()) {
            this.cachedRoot = res = URLMapper.findFileObject(this.root);
        }
        return res;
    }

    private static boolean isValid(@NullAllowed FileObject[] roots) {
        if (roots == null) {
            return false;
        }
        for (FileObject root : roots) {
            if (root.isValid()) continue;
            return false;
        }
        return true;
    }

    @CheckForNull
    private static URL getAPTSourceOutputDirectory(@NonNull FileObject sourceRoot) {
        APTUtils au = APTUtils.getIfExist(sourceRoot);
        return au != null ? au.sourceOutputDirectory() : AnnotationProcessingQuery.getAnnotationProcessingOptions(sourceRoot).sourceOutputDirectory();
    }

    private final class IndexPatch {
        private Index indexPatch;
        private URL dirty;
        private Set<String> typeFilter;

        IndexPatch() {
        }

        <T> Pair<Convertor<? super Document, T>, Index> getPatch(@NonNull Convertor<? super Document, T> delegate) {
            assert (delegate != null);
            try {
                Pair<Index, Set<String>> data = this.updateDirty();
                if (data != null) {
                    return Pair.of(new FilterConvertor<T>(data.second(), delegate), data.first());
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace(ioe);
            }
            return Pair.of(delegate, null);
        }

        synchronized void setDirtyFile(@NullAllowed URL url) throws IOException {
            this.dirty = url;
            this.indexPatch = null;
            if (url == null) {
                this.typeFilter = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        private Pair<Index, Set<String>> updateDirty() throws IOException {
            Index result;
            Set<String> filter;
            URL url;
            IndexPatch indexPatch = this;
            synchronized (indexPatch) {
                url = this.dirty;
                filter = this.typeFilter;
                result = this.indexPatch;
            }
            if (url != null) {
                List data;
                FileObject file = URLMapper.findFileObject(url);
                JavaSource js = file != null ? JavaSource.forFileObject(file) : null;
                long startTime = System.currentTimeMillis();
                List[] dataHolder = new List[1];
                if (js != null) {
                    ClassPath scp = js.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                    if (scp != null && scp.contains(file)) {
                        js.runUserActionTask(controller -> {
                            try {
                                if (controller.toPhase(JavaSource.Phase.RESOLVED).compareTo(JavaSource.Phase.RESOLVED) < 0) {
                                    return;
                                }
                                try {
                                    SourceAnalyzerFactory.SimpleAnalyzer sa = SourceAnalyzerFactory.createSimpleAnalyzer();
                                    dataHolder[0] = sa.analyseUnit(controller.getCompilationUnit(), JavaSourceAccessor.getINSTANCE().getJavacTask((CompilationInfo)controller));
                                }
                                catch (IllegalArgumentException ia) {
                                    ClassPath scp1 = controller.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                                    throw new IllegalArgumentException(String.format("Provided source path: %s root: %s", scp1 == null ? "<null>" : scp1.toString(), PersistentClassIndex.this.root.toExternalForm()), ia);
                                }
                            }
                            catch (IOException ioe) {
                                Exceptions.printStackTrace(ioe);
                            }
                        }, true);
                    } else {
                        LOGGER.log(Level.INFO, "Not updating cache for file {0}, does not belong to classpath {1}", new Object[]{FileUtil.getFileDisplayName(file), scp});
                    }
                }
                if ((data = dataHolder[0]) != null) {
                    if (filter == null) {
                        try {
                            filter = new HashSet<String>();
                            assert (file != null) : "Null file for URL: " + url;
                            FileObject root = PersistentClassIndex.this.getRoot();
                            if (root != null) {
                                String relPath = FileUtil.getRelativePath(root, file);
                                if (relPath != null) {
                                    String clsName = FileObjects.convertFolder2Package(FileObjects.stripExtension(relPath));
                                    PersistentClassIndex.this.index.query(filter, DocumentUtil.binaryNameConvertor(), DocumentUtil.declaredTypesFieldSelector(false, false), null, DocumentUtil.queryClassWithEncConvertor(true).convert(Pair.of(clsName, relPath)));
                                } else {
                                    LOGGER.log(Level.WARNING, "File: {0}({1}) is not owned by root: {2}({3})", new Object[]{FileUtil.getFileDisplayName(file), file.isValid(), FileUtil.getFileDisplayName(root), root.isValid()});
                                }
                            } else {
                                LOGGER.log(Level.WARNING, "File: {0}({1}) is has no root.", new Object[]{FileUtil.getFileDisplayName(file), file.isValid()});
                            }
                        }
                        catch (InterruptedException ie) {
                            throw new IOException(ie);
                        }
                    }
                    result = IndexManager.createMemoryIndex(DocumentUtil.createAnalyzer());
                    result.store(data, Collections.emptySet(), DocumentUtil.documentConvertor(), new NoCallConvertor(), false);
                } else {
                    filter = null;
                    result = null;
                }
                IndexPatch ie = this;
                synchronized (ie) {
                    this.dirty = null;
                    this.typeFilter = filter;
                    this.indexPatch = result;
                }
                long endTime = System.currentTimeMillis();
                LOGGER.log(Level.FINE, "PersistentClassIndex.updateDirty took: {0} ms", endTime - startTime);
            }
            if (result != null) {
                assert (filter != null);
                return Pair.of(result, filter);
            }
            assert (filter == null);
            return null;
        }
    }

    private class PIWriter
    implements ClassIndexImpl.Writer {
        PIWriter() {
            if (PersistentClassIndex.this.index instanceof Runnable) {
                ((Runnable)((Object)PersistentClassIndex.this.index)).run();
            }
        }

        @Override
        public void clear() throws IOException {
            PersistentClassIndex.this.resetPkgCache();
            PersistentClassIndex.this.index.clear();
        }

        @Override
        public void deleteAndFlush(List<Pair<Pair<BinaryName, String>, Object[]>> refs, Set<Pair<String, String>> toDelete) throws IOException {
            PersistentClassIndex.this.resetPkgCache();
            if (PersistentClassIndex.this.index instanceof Index.Transactional) {
                ((Index.Transactional)PersistentClassIndex.this.index).txStore(refs, toDelete, DocumentUtil.documentConvertor(), DocumentUtil.queryClassConvertor());
            } else {
                this.deleteAndStore(refs, toDelete);
            }
        }

        @Override
        public void commit() throws IOException {
            if (PersistentClassIndex.this.index instanceof Index.Transactional) {
                ((Index.Transactional)PersistentClassIndex.this.index).commit();
            }
        }

        @Override
        public void rollback() throws IOException {
            if (PersistentClassIndex.this.index instanceof Index.Transactional) {
                ((Index.Transactional)PersistentClassIndex.this.index).rollback();
            }
        }

        @Override
        public void deleteAndStore(List<Pair<Pair<BinaryName, String>, Object[]>> refs, Set<Pair<String, String>> toDelete) throws IOException {
            PersistentClassIndex.this.resetPkgCache();
            PersistentClassIndex.this.index.store(refs, toDelete, DocumentUtil.documentConvertor(), DocumentUtil.queryClassConvertor(), true);
        }
    }

    private static final class FreqCollector
    implements StoppableConvertor<Index.WithTermFrequencies.TermFreq, Void> {
        private final int postfixLen = ClassIndexImpl.UsageType.values().length;
        private final String fieldName;
        private final Map<String, Integer> typeFreq;
        private final Map<String, Integer> pkgFreq;

        FreqCollector(@NonNull Term startTerm, @NonNull Map<String, Integer> typeFreqs, @NonNull Map<String, Integer> pkgFreq) {
            this.fieldName = startTerm.field();
            this.typeFreq = typeFreqs;
            this.pkgFreq = pkgFreq;
        }

        @Override
        @CheckForNull
        public Void convert(@NonNull Index.WithTermFrequencies.TermFreq param) throws StoppableConvertor.Stop {
            Term term = param.getTerm();
            if (this.fieldName != term.field()) {
                throw new StoppableConvertor.Stop();
            }
            int docCount = param.getFreq();
            String encBinName = term.text();
            String binName = encBinName.substring(0, encBinName.length() - this.postfixLen);
            int dotIndex = binName.lastIndexOf(46);
            String pkgName = dotIndex == -1 ? "" : binName.substring(0, dotIndex);
            Integer typeCount = this.typeFreq.get(binName);
            Integer pkgCount = this.pkgFreq.get(pkgName);
            this.typeFreq.put(binName, typeCount == null ? docCount : docCount + typeCount);
            this.pkgFreq.put(pkgName, pkgCount == null ? docCount : docCount + pkgCount);
            return null;
        }
    }

    private static class TeeCollection<T>
    extends AbstractCollection<T> {
        private final Collection<T> primary;
        private final Collection<T> secondary;

        TeeCollection(@NonNull Collection<T> primary, @NonNull Collection<T> secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        @Override
        public Iterator<T> iterator() {
            throw new UnsupportedOperationException("Not supported operation.");
        }

        @Override
        public int size() {
            return this.primary.size();
        }

        @Override
        public boolean add(T e) {
            boolean result = this.primary.add(e);
            this.secondary.add(e);
            return result;
        }
    }

    private static class NoCallConvertor<F, T>
    implements Convertor<F, T> {
        private NoCallConvertor() {
        }

        @Override
        public T convert(F p) {
            throw new IllegalStateException();
        }
    }

    private static class FilterConvertor<T>
    implements Convertor<Document, T> {
        private final Set<String> toExclude;
        private final Convertor<? super Document, T> delegate;

        private FilterConvertor(@NonNull Set<String> toExclude, @NonNull Convertor<? super Document, T> delegate) {
            assert (toExclude != null);
            assert (delegate != null);
            this.toExclude = toExclude;
            this.delegate = delegate;
        }

        @Override
        @CheckForNull
        public T convert(@NonNull Document doc) {
            String rawName = DocumentUtil.getBinaryName(doc);
            return this.toExclude.contains(rawName) ? null : (T)this.delegate.convert(doc);
        }
    }
}

