/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.FlaggedClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.project.LookupMerger;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

final class ClassPathProviderMerger
implements LookupMerger<ClassPathProvider> {
    private final ClassPathProvider defaultProvider;

    ClassPathProviderMerger(ClassPathProvider defaultProvider) {
        assert (defaultProvider != null);
        this.defaultProvider = defaultProvider;
    }

    @Override
    public Class<ClassPathProvider> getMergeableClass() {
        return ClassPathProvider.class;
    }

    @Override
    public ClassPathProvider merge(Lookup lookup) {
        return new CPProvider(lookup);
    }

    private class CPProvider
    implements ClassPathProvider {
        private final Lookup lookup;
        private final Map<FileObject, Map<String, ClassPath>> cpCache = new HashMap<FileObject, Map<String, ClassPath>>();

        public CPProvider(Lookup lookup) {
            assert (lookup != null);
            this.lookup = lookup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClassPath findClassPath(FileObject file, String type) {
            Map<FileObject, Map<String, ClassPath>> map = this.cpCache;
            synchronized (map) {
                ClassPath path;
                Map<String, ClassPath> cptype = this.cpCache.get(file);
                if (cptype != null && (path = cptype.get(type)) != null) {
                    return path;
                }
            }
            ProxyClassPathImplementation result = new ProxyClassPathImplementation(ClassPathProviderMerger.this.defaultProvider, this.lookup, file, type);
            if (!result.hasAnyResults()) {
                return null;
            }
            ClassPath cp = ClassPathFactory.createClassPath(result);
            Map<FileObject, Map<String, ClassPath>> map2 = this.cpCache;
            synchronized (map2) {
                Map<String, ClassPath> cptype = this.cpCache.get(file);
                if (cptype == null) {
                    cptype = new HashMap<String, ClassPath>();
                    this.cpCache.put(file, cptype);
                }
                cptype.put(type, cp);
            }
            return cp;
        }
    }

    private static class ProxyFilteringCPI
    implements FilteringPathResourceImplementation,
    PropertyChangeListener {
        static final String PROP_CP_FLAGS = "classPathFlags";
        private final ClassPath classpath;
        private final PropertyChangeSupport changeSupport;

        private ProxyFilteringCPI(ClassPath path) {
            assert (path != null);
            this.classpath = path;
            this.changeSupport = new PropertyChangeSupport(this);
            this.classpath.addPropertyChangeListener(WeakListeners.propertyChange(this, this.classpath));
        }

        @Override
        public boolean includes(URL root, String resource) {
            for (ClassPath.Entry ent : this.classpath.entries()) {
                if (!ent.getURL().equals(root)) continue;
                return ent.includes(resource);
            }
            return false;
        }

        @Override
        public URL[] getRoots() {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (ClassPath.Entry ent : this.classpath.entries()) {
                urls.add(ent.getURL());
            }
            return urls.toArray(new URL[0]);
        }

        @Override
        public ClassPathImplementation getContent() {
            return null;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("entries".equals(propName)) {
                this.changeSupport.firePropertyChange("roots", null, null);
            } else if ("includes".equals(propName)) {
                this.changeSupport.firePropertyChange("includes", null, null);
            } else if ("flags".equals(propName)) {
                this.changeSupport.firePropertyChange(PROP_CP_FLAGS, null, null);
            }
        }

        @NonNull
        Set<ClassPath.Flag> getClassPathFlags() {
            return this.classpath.getFlags();
        }
    }

    class ProxyClassPathImplementation
    implements FlaggedClassPathImplementation {
        private ProxyFilteringCPI[] classPaths;
        private List<PathResourceImplementation> resourcesCache;
        private Set<ClassPath.Flag> flagsCache;
        private ArrayList<PropertyChangeListener> listeners;
        private LookupListener lookupList;
        private PropertyChangeListener flagsListener;
        private Lookup.Result<ClassPathProvider> providers;
        private ClassPathProvider mainProvider;
        private FileObject file;
        private String type;
        private boolean hasAny = false;

        public ProxyClassPathImplementation(ClassPathProvider dominant, Lookup context, FileObject fo, String type) {
            assert (dominant != null);
            this.type = type;
            this.file = fo;
            this.mainProvider = dominant;
            this.providers = context.lookupResult(ClassPathProvider.class);
            this.flagsListener = ev -> {
                if ("classPathFlags".equals(ev.getPropertyName())) {
                    ProxyClassPathImplementation proxyClassPathImplementation = this;
                    synchronized (proxyClassPathImplementation) {
                        this.flagsCache = null;
                    }
                    this.firePropertyChange(new PropertyChangeEvent(this, "flags", null, null));
                }
            };
            this.checkProviders();
            this.lookupList = ev -> this.checkProviders();
            this.providers.addLookupListener(this.lookupList);
        }

        boolean hasAnyResults() {
            return this.hasAny;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkProviders() {
            boolean hasAnyVote = false;
            ArrayList<ProxyFilteringCPI> impls = new ArrayList<ProxyFilteringCPI>();
            ClassPath mainResult = this.mainProvider.findClassPath(this.file, this.type);
            if (mainResult != null) {
                hasAnyVote = true;
                impls.add(new ProxyFilteringCPI(mainResult));
            }
            for (ClassPathProvider prvd : this.providers.allInstances()) {
                ClassPath path = prvd.findClassPath(this.file, this.type);
                if (path == null) continue;
                hasAnyVote = true;
                impls.add(new ProxyFilteringCPI(path));
            }
            ProxyClassPathImplementation proxyClassPathImplementation = this;
            synchronized (proxyClassPathImplementation) {
                this.hasAny = hasAnyVote;
                if (this.classPaths != null) {
                    for (ProxyFilteringCPI pr : this.classPaths) {
                        pr.removePropertyChangeListener(this.flagsListener);
                    }
                }
                for (ProxyFilteringCPI pr : this.classPaths = impls.toArray(new ProxyFilteringCPI[0])) {
                    pr.addPropertyChangeListener(this.flagsListener);
                }
                this.resourcesCache = null;
                this.flagsCache = null;
            }
            this.firePropertyChange(new PropertyChangeEvent(this, "resources", null, null));
            this.firePropertyChange(new PropertyChangeEvent(this, "flags", null, null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<ClassPath.Flag> getFlags() {
            ProxyClassPathImplementation proxyClassPathImplementation = this;
            synchronized (proxyClassPathImplementation) {
                if (this.flagsCache != null) {
                    return this.flagsCache;
                }
            }
            EnumSet<ClassPath.Flag> flags = EnumSet.noneOf(ClassPath.Flag.class);
            for (ProxyFilteringCPI impl : this.classPaths) {
                flags.addAll(impl.getClassPathFlags());
            }
            ProxyClassPathImplementation proxyClassPathImplementation2 = this;
            synchronized (proxyClassPathImplementation2) {
                if (this.flagsCache == null) {
                    this.flagsCache = Collections.unmodifiableSet(flags);
                }
                return this.flagsCache;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<? extends PathResourceImplementation> getResources() {
            ProxyClassPathImplementation proxyClassPathImplementation = this;
            synchronized (proxyClassPathImplementation) {
                if (this.resourcesCache != null) {
                    return this.resourcesCache;
                }
            }
            ArrayList<ProxyFilteringCPI> result = new ArrayList<ProxyFilteringCPI>(this.classPaths.length * 10);
            for (ProxyFilteringCPI cpImpl : this.classPaths) {
                result.add(cpImpl);
            }
            ProxyClassPathImplementation proxyClassPathImplementation2 = this;
            synchronized (proxyClassPathImplementation2) {
                if (this.resourcesCache == null) {
                    this.resourcesCache = Collections.unmodifiableList(result);
                }
                return this.resourcesCache;
            }
        }

        @Override
        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(listener);
        }

        @Override
        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(listener);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("[");
            for (ProxyFilteringCPI cpImpl : this.classPaths) {
                builder.append(cpImpl.toString());
                builder.append(", ");
            }
            builder.append("]");
            return builder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void firePropertyChange(PropertyChangeEvent event) {
            PropertyChangeListener[] propertyChangeListenerArray = this;
            synchronized (this) {
                if (this.listeners == null) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return;
                }
                PropertyChangeListener[] _listeners = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                for (PropertyChangeListener l : _listeners) {
                    l.propertyChange(event);
                }
                return;
            }
        }
    }
}

