/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.cpplite.project.ui;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.netbeans.modules.cpplite.project.BuildConfiguration;
import org.netbeans.modules.cpplite.project.CPPLiteProject;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer.Category;
import org.netbeans.spi.project.ui.support.ProjectCustomizer.CompositeCategoryProvider;
import org.openide.util.Lookup;

/**
 *
 * @author lahvac
 */
public class Build extends javax.swing.JPanel {

    /**
     * Creates new form Build
     */
    public Build() {
        initComponents();
    }

    private String toString(BuildConfiguration config, String action) {
        List<List<String>> executables = config.executablesFor(action);
        if (executables == null) return "";
        return executables.stream().map(commands -> commands.stream().collect(Collectors.joining(" "))).collect(Collectors.joining("\n"));
    }

    public void load(BuildConfiguration config) {
        name.setText(config.getName());
        build.setText(toString(config, ActionProvider.COMMAND_BUILD));
        clean.setText(toString(config, ActionProvider.COMMAND_CLEAN));
        run.setText(toString(config, ActionProvider.COMMAND_RUN));
    }

    public BuildConfiguration save() {
        Map<String, List<List<String>>> commands = new HashMap<>();

        commands.put(ActionProvider.COMMAND_BUILD, fromString(build.getText()));
        commands.put(ActionProvider.COMMAND_CLEAN, fromString(clean.getText()));
        commands.put(ActionProvider.COMMAND_RUN, fromString(run.getText()));

        return new BuildConfiguration(name.getText(), commands);
    }
    
    private List<List<String>> fromString(String text) {
        return Arrays.stream(text.split("\n"))
                     .filter(l -> !l.isEmpty())
                     .map(l -> Arrays.stream(l.split(" ")).collect(Collectors.toList()))
                     .collect(Collectors.toList());
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        name = new javax.swing.JTextField();
        jScrollPane1 = new javax.swing.JScrollPane();
        build = new javax.swing.JTextArea();
        jScrollPane2 = new javax.swing.JScrollPane();
        clean = new javax.swing.JTextArea();
        jLabel3 = new javax.swing.JLabel();
        jScrollPane3 = new javax.swing.JScrollPane();
        run = new javax.swing.JTextArea();
        jLabel4 = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(Build.class, "Build.jLabel1.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(Build.class, "Build.jLabel2.text")); // NOI18N

        name.setText(org.openide.util.NbBundle.getMessage(Build.class, "Build.name.text")); // NOI18N

        build.setColumns(20);
        build.setRows(3);
        jScrollPane1.setViewportView(build);

        clean.setColumns(20);
        clean.setRows(3);
        jScrollPane2.setViewportView(clean);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(Build.class, "Build.jLabel3.text")); // NOI18N

        run.setColumns(20);
        run.setRows(3);
        jScrollPane3.setViewportView(run);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel4, org.openide.util.NbBundle.getMessage(Build.class, "Build.jLabel4.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                        .addComponent(jLabel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addComponent(jLabel3)
                    .addComponent(jLabel4))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane3, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 242, Short.MAX_VALUE)
                    .addComponent(jScrollPane2)
                    .addComponent(name)
                    .addComponent(jScrollPane1)))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(name, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel2)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel3))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel4)))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea build;
    private javax.swing.JTextArea clean;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTextField name;
    private javax.swing.JTextArea run;
    // End of variables declaration//GEN-END:variables

    @CompositeCategoryProvider.Registration(projectType=CPPLiteProject.PROJECT_KEY, position=200)
    public static CompositeCategoryProvider createCategoryProvider() {
        return new CompositeCategoryProvider() {
            @Override
            public Category createCategory(Lookup context) {
                return Category.create("build", "Build", null);
            }
            @Override
            public JComponent createComponent(Category category, Lookup context) {
                CPPLiteProject prj = context.lookup(CPPLiteProject.class);
                Build panel = new Build();
                panel.load(prj.getActiveBuildConfiguration());
                category.setOkButtonListener(evt -> {
                    prj.setActiveBuildConfiguration(panel.save());
                });
                category.setStoreListener(evt -> prj.getActiveBuildConfiguration().save(CPPLiteProject.getBuildPreferences(prj.getProjectDirectory())));
                return panel;
            }
        };
    }
}
