/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.command.process;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.nifi.bootstrap.command.process.ProcessHandleProvider;
import org.apache.nifi.bootstrap.configuration.ConfigurationProvider;
import org.apache.nifi.bootstrap.configuration.SystemProperty;

public class StandardProcessHandleProvider
implements ProcessHandleProvider {
    private static final String PROPERTIES_ARGUMENT = "-D%s=%s";
    private final ConfigurationProvider configurationProvider;

    public StandardProcessHandleProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = Objects.requireNonNull(configurationProvider);
    }

    @Override
    public Optional<ProcessHandle> findApplicationProcessHandle() {
        Path applicationProperties = this.configurationProvider.getApplicationProperties();
        return this.findProcessHandle(SystemProperty.APPLICATION_PROPERTIES, applicationProperties);
    }

    @Override
    public Optional<ProcessHandle> findBootstrapProcessHandle() {
        Path bootstrapConfiguration = this.configurationProvider.getBootstrapConfiguration();
        return this.findProcessHandle(SystemProperty.BOOTSTRAP_CONFIGURATION, bootstrapConfiguration);
    }

    private Optional<ProcessHandle> findProcessHandle(SystemProperty systemProperty, Path configuration) {
        String propertiesArgument = PROPERTIES_ARGUMENT.formatted(systemProperty.getProperty(), configuration);
        ProcessHandle currentProcessHandle = ProcessHandle.current();
        return ProcessHandle.allProcesses().filter(Predicate.not(currentProcessHandle::equals)).filter(processHandle -> {
            boolean matched;
            ProcessHandle.Info processHandleInfo = processHandle.info();
            Optional<String[]> processArguments = processHandleInfo.arguments();
            if (processArguments.isPresent()) {
                String[] arguments = processArguments.get();
                matched = Arrays.stream(arguments).anyMatch(propertiesArgument::contentEquals);
            } else {
                matched = false;
            }
            return matched;
        }).findFirst();
    }
}

