/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization;

import org.apache.nifi.registry.security.authorization.AccessPolicyProviderInitializationContext;
import org.apache.nifi.registry.security.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.registry.security.authorization.ConfigurableAccessPolicyProvider;
import org.apache.nifi.registry.security.authorization.UserGroupProvider;
import org.apache.nifi.registry.security.authorization.UserGroupProviderLookup;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.util.PropertyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurableAccessPolicyProvider
implements ConfigurableAccessPolicyProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConfigurableAccessPolicyProvider.class);
    public static final String PROP_USER_GROUP_PROVIDER = "User Group Provider";
    private UserGroupProvider userGroupProvider;
    private UserGroupProviderLookup userGroupProviderLookup;

    public final void initialize(AccessPolicyProviderInitializationContext initializationContext) throws SecurityProviderCreationException {
        LOGGER.debug("Initializing {}", (Object)this.getClass().getCanonicalName());
        this.userGroupProviderLookup = initializationContext.getUserGroupProviderLookup();
        this.doInitialize(initializationContext);
        LOGGER.debug("Done initializing {}", (Object)this.getClass().getCanonicalName());
    }

    protected void doInitialize(AccessPolicyProviderInitializationContext initializationContext) throws SecurityProviderCreationException {
    }

    public final void onConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
        try {
            LOGGER.debug("Configuring {}", (Object)this.getClass().getCanonicalName());
            PropertyValue userGroupProviderIdentifier = configurationContext.getProperty(PROP_USER_GROUP_PROVIDER);
            if (!userGroupProviderIdentifier.isSet()) {
                throw new SecurityProviderCreationException("The user group provider must be specified.");
            }
            this.userGroupProvider = this.userGroupProviderLookup.getUserGroupProvider(userGroupProviderIdentifier.getValue());
            if (this.userGroupProvider == null) {
                throw new SecurityProviderCreationException("Unable to locate user group provider with identifier '" + userGroupProviderIdentifier.getValue() + "'");
            }
            this.doOnConfigured(configurationContext);
            LOGGER.debug("Done configuring {}", (Object)this.getClass().getCanonicalName());
        }
        catch (Exception e) {
            throw new SecurityProviderCreationException((Throwable)e);
        }
    }

    protected void doOnConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
    }

    public UserGroupProvider getUserGroupProvider() {
        return this.userGroupProvider;
    }
}

