/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint.net;

import com.sleepycat.je.rep.net.InstanceLogger;
import com.sleepycat.je.rep.net.InstanceParams;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;

public class SSLStdHostVerifier
implements HostnameVerifier {
    private final InstanceLogger logger;
    private static final int ALTNAME_DNS = 2;
    private static final int ALTNAME_IP = 7;

    public SSLStdHostVerifier(InstanceParams params) {
        this.logger = params.getContext().getLoggerFactory().getLogger(this.getClass());
    }

    @Override
    public boolean verify(String targetHost, SSLSession sslSession) {
        X500Principal x500Principal;
        String name;
        if (targetHost == null) {
            return false;
        }
        Principal principal = null;
        Certificate[] peerCerts = null;
        try {
            principal = sslSession.getPeerPrincipal();
            peerCerts = sslSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException pue) {
            return false;
        }
        if (principal != null && principal instanceof X500Principal && targetHost.equalsIgnoreCase(name = (x500Principal = (X500Principal)principal).getName("RFC1779"))) {
            return true;
        }
        if (peerCerts[0] instanceof X509Certificate) {
            X509Certificate peerCert = (X509Certificate)peerCerts[0];
            Collection<List<?>> altNames = null;
            try {
                altNames = peerCert.getSubjectAlternativeNames();
            }
            catch (CertificateParsingException cpe) {
                X500Principal issuerPrinc = peerCert.getIssuerX500Principal();
                BigInteger serNo = peerCert.getSerialNumber();
                this.logger.log(Level.INFO, "Unable to parse peer certificate: issuer = " + issuerPrinc + ", serialNumber = " + serNo);
            }
            if (altNames == null) {
                return false;
            }
            for (List<?> altName : altNames) {
                String nameValue;
                int nameType = (Integer)altName.get(0);
                if (nameType != 7 && nameType != 2 || !targetHost.equals(nameValue = (String)altName.get(1))) continue;
                return true;
            }
        }
        return false;
    }
}

