/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.resource;

import jakarta.servlet.Servlet;
import java.util.Iterator;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.servlets.resolver.internal.resource.ServletResource;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;

public class ServletResourceProvider
extends ResourceProvider<Object> {
    private final Servlet servlet;
    private final Set<String> resourcePaths;
    private final String resourceSuperType;
    private final Set<String> resourceSuperTypeMarkers;

    ServletResourceProvider(Servlet servlet, Set<String> resourcePaths, Set<String> resourceSuperTypeMarkers, String resourceSuperType) {
        this.servlet = servlet;
        this.resourcePaths = resourcePaths;
        this.resourceSuperType = resourceSuperType;
        this.resourceSuperTypeMarkers = resourceSuperTypeMarkers;
    }

    public Resource getResource(ResolveContext<Object> ctx, String path, ResourceContext resourceContext, Resource parent) {
        if (this.resourcePaths.contains(path)) {
            if (this.resourceSuperTypeMarkers.contains(path)) {
                return new ServletResource(ctx.getResourceResolver(), null, path, this.resourceSuperType);
            }
            return new ServletResource(ctx.getResourceResolver(), this.servlet, path, this.resourceSuperType);
        }
        ResourceProvider parentProvider = ctx.getParentResourceProvider();
        if (parentProvider != null) {
            Resource useParent = parent instanceof ServletResource ? null : parent;
            return parentProvider.getResource(ctx.getParentResolveContext(), path, resourceContext, useParent);
        }
        return null;
    }

    public Iterator<Resource> listChildren(ResolveContext<Object> ctx, Resource parent) {
        ResourceProvider parentProvider = ctx.getParentResourceProvider();
        if (parentProvider != null) {
            return parentProvider.listChildren(ctx.getParentResolveContext(), parent);
        }
        return null;
    }

    Set<String> getServletPaths() {
        return this.resourcePaths;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": servlet=" + this.servlet.getClass().getName() + ", paths=" + String.valueOf(this.resourcePaths);
    }
}

