/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import java.util.List;
import org.springframework.binding.message.DefaultMessageContext;
import org.springframework.binding.message.MessageContext;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;
import org.springframework.webflow.test.MockExternalContext;
import org.springframework.webflow.test.MockFlowExecutionContext;

public class MockRequestContext
implements RequestContext {
    private FlowExecutionContext flowExecutionContext;
    private ExternalContext externalContext;
    private MessageContext messageContext;
    private MutableAttributeMap<Object> requestScope = new LocalAttributeMap<Object>();
    private MutableAttributeMap<Object> attributes = new LocalAttributeMap<Object>();
    private Event currentEvent;
    private Transition currentTransition;
    private View currentView;

    public MockRequestContext() {
        this(new MockFlowExecutionContext());
    }

    public MockRequestContext(Flow flow) {
        this(new MockFlowExecutionContext(flow));
    }

    public MockRequestContext(ParameterMap requestParameterMap) {
        this.flowExecutionContext = new MockFlowExecutionContext();
        this.externalContext = new MockExternalContext(requestParameterMap);
        this.messageContext = new DefaultMessageContext();
    }

    public MockRequestContext(FlowExecutionContext flowExecutionContext) {
        this.flowExecutionContext = flowExecutionContext;
        this.externalContext = new MockExternalContext();
        this.messageContext = new DefaultMessageContext();
    }

    @Override
    public FlowDefinition getActiveFlow() {
        return this.getFlowExecutionContext().getActiveSession().getDefinition();
    }

    @Override
    public StateDefinition getCurrentState() {
        return this.getFlowExecutionContext().getActiveSession().getState();
    }

    @Override
    public TransitionDefinition getMatchingTransition(String eventId) throws IllegalStateException {
        TransitionableState state = (TransitionableState)this.getFlowExecutionContext().getActiveSession().getState();
        TransitionDefinition transition = state.getTransition(eventId);
        if (transition == null) {
            transition = this.getRootFlow().getGlobalTransition(eventId);
        }
        return transition;
    }

    @Override
    public boolean inViewState() {
        return this.getFlowExecutionContext().isActive() && this.getCurrentState() != null && this.getCurrentState().isViewState();
    }

    @Override
    public MutableAttributeMap<Object> getRequestScope() {
        return this.requestScope;
    }

    @Override
    public MutableAttributeMap<Object> getFlashScope() {
        return this.getMockFlowExecutionContext().getFlashScope();
    }

    @Override
    public MutableAttributeMap<Object> getViewScope() throws IllegalStateException {
        return this.getMockFlowExecutionContext().getActiveSession().getViewScope();
    }

    @Override
    public MutableAttributeMap<Object> getFlowScope() {
        return this.getFlowExecutionContext().getActiveSession().getScope();
    }

    @Override
    public MutableAttributeMap<Object> getConversationScope() {
        return this.getMockFlowExecutionContext().getConversationScope();
    }

    @Override
    public ParameterMap getRequestParameters() {
        return this.externalContext.getRequestParameterMap();
    }

    @Override
    public MessageContext getMessageContext() {
        return this.messageContext;
    }

    @Override
    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    @Override
    public FlowExecutionContext getFlowExecutionContext() {
        return this.flowExecutionContext;
    }

    @Override
    public Event getCurrentEvent() {
        return this.currentEvent;
    }

    @Override
    public TransitionDefinition getCurrentTransition() {
        return this.currentTransition;
    }

    @Override
    public View getCurrentView() {
        return this.currentView;
    }

    @Override
    public MutableAttributeMap<Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getFlowExecutionUrl() {
        if (this.flowExecutionContext.getKey() == null) {
            throw new IllegalStateException("Flow execution key not yet assigned; unable to build the flow execution url");
        }
        String flowDefinitionId = this.flowExecutionContext.getDefinition().getId();
        return this.externalContext.getFlowExecutionUrl(flowDefinitionId, this.flowExecutionContext.getKey().toString());
    }

    public void sendFlowExecutionRedirect() {
        if (this.flowExecutionContext.getKey() == null) {
            throw new IllegalStateException("Flow execution key not yet assigned; unable to send a flow execution redirect request");
        }
        this.externalContext.requestFlowExecutionRedirect();
    }

    public void setActiveSession(FlowSession flowSession) {
        this.getMockFlowExecutionContext().setActiveSession(flowSession);
    }

    public void setExternalContext(ExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    public void setFlowExecutionContext(FlowExecutionContext flowExecutionContext) {
        this.flowExecutionContext = flowExecutionContext;
    }

    public void setCurrentEvent(Event event) {
        this.currentEvent = event;
    }

    public void setCurrentTransition(Transition transition) {
        this.currentTransition = transition;
    }

    public void setCurrentView(View currentView) {
        this.currentView = currentView;
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public void removeAttribute(String attributeName) {
        this.attributes.remove(attributeName);
    }

    public void putRequestParameter(String parameterName, String parameterValue) {
        this.getMockExternalContext().putRequestParameter(parameterName, parameterValue);
    }

    public void putRequestParameter(String parameterName, String[] parameterValues) {
        this.getMockExternalContext().putRequestParameter(parameterName, parameterValues);
    }

    public void putRequestParameter(String parameterName, MultipartFile parameterValue) {
        this.getMockExternalContext().putRequestParameter(parameterName, parameterValue);
    }

    public void putRequestParameter(String parameterName, List<MultipartFile> parameterValue) {
        this.getMockExternalContext().putRequestParameter(parameterName, parameterValue);
    }

    public Flow getRootFlow() {
        return this.getMockFlowExecutionContext().getDefinitionInternal();
    }

    public MutableAttributeMap<Object> getAttributeMap() {
        return this.attributes;
    }

    public MockFlowExecutionContext getMockFlowExecutionContext() {
        return (MockFlowExecutionContext)this.flowExecutionContext;
    }

    public MockExternalContext getMockExternalContext() {
        return (MockExternalContext)this.externalContext;
    }
}

