/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.PlainSchemaCheck;

public class PlainSchemaValidator
extends AbstractValidator<PlainSchemaCheck, PlainSchema> {
    public boolean isValid(PlainSchema schema, ConstraintValidatorContext context) {
        boolean isValid;
        boolean bl = isValid = schema.getType() != AttrSchemaType.Enum || StringUtils.isNotBlank((CharSequence)schema.getEnumerationValues());
        if (!isValid) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(PlainSchemaValidator.getTemplate(EntityViolationType.InvalidSchemaEnum, "Enumeration values missing")).addPropertyNode("enumerationValues").addConstraintViolation();
        } else {
            boolean bl2 = isValid = schema.getType() != AttrSchemaType.Encrypted || schema.getSecretKey() != null && schema.getCipherAlgorithm() != null;
            if (!isValid) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(PlainSchemaValidator.getTemplate(EntityViolationType.InvalidSchemaEncrypted, "SecretKey or CipherAlgorithm missing")).addPropertyNode("secretKey").addPropertyNode("cipherAlgorithm").addConstraintViolation();
            } else {
                boolean bl3 = isValid = !schema.isMultivalue() || !schema.isUniqueConstraint();
                if (!isValid) {
                    context.disableDefaultConstraintViolation();
                    context.buildConstraintViolationWithTemplate(PlainSchemaValidator.getTemplate(EntityViolationType.InvalidSchemaMultivalueUnique, "Cannot contemporary be multivalue and have unique constraint")).addPropertyNode("multiValue").addConstraintViolation();
                }
            }
        }
        return isValid;
    }
}

