/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history;

import java.util.Date;
import java.util.List;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.persistence.cache.EntityCache;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.HistoryConfigurationSettings;
import org.flowable.engine.impl.history.HistoryManager;
import org.flowable.engine.impl.persistence.AbstractManager;
import org.flowable.engine.impl.persistence.entity.CommentEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.task.service.HistoricTaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public abstract class AbstractHistoryManager
extends AbstractManager
implements HistoryManager {
    public AbstractHistoryManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    protected HistoryConfigurationSettings getHistoryConfigurationSettings() {
        return this.processEngineConfiguration.getHistoryConfigurationSettings();
    }

    @Override
    public boolean isHistoryLevelAtLeast(HistoryLevel level) {
        return this.isHistoryLevelAtLeast(level, null);
    }

    @Override
    public boolean isHistoryLevelAtLeast(HistoryLevel level, String processDefinitionId) {
        return this.getHistoryConfigurationSettings().isHistoryLevelAtLeast(level, processDefinitionId);
    }

    @Override
    public boolean isHistoryEnabled() {
        return this.getHistoryConfigurationSettings().isHistoryEnabled();
    }

    @Override
    public boolean isHistoryEnabled(String processDefinitionId) {
        return this.getHistoryConfigurationSettings().isHistoryEnabled(processDefinitionId);
    }

    @Override
    public void createIdentityLinkComment(TaskEntity taskEntity, String userId, String groupId, String type, boolean create) {
        this.createIdentityLinkComment(taskEntity, userId, groupId, type, create, false);
    }

    @Override
    public void createUserIdentityLinkComment(TaskEntity taskEntity, String userId, String type, boolean create) {
        this.createIdentityLinkComment(taskEntity, userId, null, type, create, false);
    }

    @Override
    public void createGroupIdentityLinkComment(TaskEntity taskEntity, String groupId, String type, boolean create) {
        this.createIdentityLinkComment(taskEntity, null, groupId, type, create, false);
    }

    @Override
    public void createUserIdentityLinkComment(TaskEntity taskEntity, String userId, String type, boolean create, boolean forceNullUserId) {
        this.createIdentityLinkComment(taskEntity, userId, null, type, create, forceNullUserId);
    }

    @Override
    public void createIdentityLinkComment(TaskEntity taskEntity, String userId, String groupId, String type, boolean create, boolean forceNullUserId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, taskEntity.getProcessDefinitionId())) {
            String authenticatedUserId = Authentication.getAuthenticatedUserId();
            CommentEntity comment = (CommentEntity)this.getCommentEntityManager().create();
            comment.setUserId(authenticatedUserId);
            comment.setType("event");
            comment.setTime(this.getClock().getCurrentTime());
            comment.setTaskId(taskEntity.getId());
            if (userId != null || forceNullUserId) {
                if (create && !forceNullUserId) {
                    comment.setAction("AddUserLink");
                } else {
                    comment.setAction("DeleteUserLink");
                }
                comment.setMessage(new String[]{userId, type});
            } else {
                if (create) {
                    comment.setAction("AddGroupLink");
                } else {
                    comment.setAction("DeleteGroupLink");
                }
                comment.setMessage(new String[]{groupId, type});
            }
            this.getCommentEntityManager().insert(comment);
        }
    }

    @Override
    public void createProcessInstanceIdentityLinkComment(ExecutionEntity processInstance, String userId, String groupId, String type, boolean create) {
        this.createProcessInstanceIdentityLinkComment(processInstance, userId, groupId, type, create, false);
    }

    @Override
    public void createProcessInstanceIdentityLinkComment(ExecutionEntity processInstance, String userId, String groupId, String type, boolean create, boolean forceNullUserId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, processInstance.getProcessDefinitionId())) {
            String authenticatedUserId = Authentication.getAuthenticatedUserId();
            CommentEntity comment = (CommentEntity)this.getCommentEntityManager().create();
            comment.setUserId(authenticatedUserId);
            comment.setType("event");
            comment.setTime(this.getClock().getCurrentTime());
            comment.setProcessInstanceId(processInstance.getId());
            if (userId != null || forceNullUserId) {
                if (create && !forceNullUserId) {
                    comment.setAction("AddUserLink");
                } else {
                    comment.setAction("DeleteUserLink");
                }
                comment.setMessage(new String[]{userId, type});
            } else {
                if (create) {
                    comment.setAction("AddGroupLink");
                } else {
                    comment.setAction("DeleteGroupLink");
                }
                comment.setMessage(new String[]{groupId, type});
            }
            this.getCommentEntityManager().insert(comment);
        }
    }

    @Override
    public void createAttachmentComment(TaskEntity task, ExecutionEntity processInstance, String attachmentName, boolean create) {
        String processDefinitionId = null;
        if (processInstance != null) {
            processDefinitionId = processInstance.getProcessDefinitionId();
        } else if (task != null) {
            processDefinitionId = task.getProcessDefinitionId();
        }
        if (this.isHistoryEnabled(processDefinitionId)) {
            String userId = Authentication.getAuthenticatedUserId();
            CommentEntity comment = (CommentEntity)this.getCommentEntityManager().create();
            comment.setUserId(userId);
            comment.setType("event");
            comment.setTime(this.getClock().getCurrentTime());
            if (task != null) {
                comment.setTaskId(task.getId());
            }
            if (processInstance != null) {
                comment.setProcessInstanceId(processInstance.getId());
            }
            if (create) {
                comment.setAction("AddAttachment");
            } else {
                comment.setAction("DeleteAttachment");
            }
            comment.setMessage(attachmentName);
            this.getCommentEntityManager().insert(comment);
        }
    }

    @Override
    public void updateActivity(ExecutionEntity childExecution, String oldActivityId, FlowElement newFlowElement, TaskEntity task, Date updateTime) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricActivityInstanceEntityManager historicActivityInstanceEntityManager = CommandContextUtil.getHistoricActivityInstanceEntityManager();
            List<HistoricActivityInstanceEntity> historicActivityInstances = historicActivityInstanceEntityManager.findHistoricActivityInstancesByExecutionAndActivityId(childExecution.getId(), oldActivityId);
            for (HistoricActivityInstanceEntity historicActivityInstance : historicActivityInstances) {
                historicActivityInstance.setProcessDefinitionId(childExecution.getProcessDefinitionId());
                historicActivityInstance.setActivityId(childExecution.getActivityId());
                historicActivityInstance.setActivityName(newFlowElement.getName());
            }
        }
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            HistoricTaskService historicTaskService = this.processEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService();
            historicTaskService.recordTaskInfoChange(task, updateTime, (AbstractEngineConfiguration)this.processEngineConfiguration);
        }
    }

    protected HistoricActivityInstanceEntity getHistoricActivityInstanceFromCache(String executionId, String activityId, boolean endTimeMustBeNull) {
        List cachedHistoricActivityInstances = this.getEntityCache().findInCache(HistoricActivityInstanceEntity.class);
        for (HistoricActivityInstanceEntity cachedHistoricActivityInstance : cachedHistoricActivityInstances) {
            if (activityId == null || !activityId.equals(cachedHistoricActivityInstance.getActivityId()) || endTimeMustBeNull && cachedHistoricActivityInstance.getEndTime() != null || !executionId.equals(cachedHistoricActivityInstance.getExecutionId())) continue;
            return cachedHistoricActivityInstance;
        }
        return null;
    }

    @Override
    public HistoricActivityInstanceEntity findHistoricActivityInstance(ExecutionEntity execution, boolean endTimeMustBeNull) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, execution.getProcessDefinitionId())) {
            String activityId = this.getActivityIdForExecution(execution);
            return activityId != null ? this.findHistoricActivityInstance(execution, activityId, endTimeMustBeNull) : null;
        }
        return null;
    }

    protected String getActivityIdForExecution(ExecutionEntity execution) {
        String activityId = null;
        if (execution.getCurrentFlowElement() instanceof FlowNode) {
            activityId = execution.getCurrentFlowElement().getId();
        } else if (execution.getCurrentFlowElement() instanceof SequenceFlow && execution.getCurrentFlowableListener() == null) {
            activityId = ((SequenceFlow)execution.getCurrentFlowElement()).getSourceFlowElement().getId();
        }
        return activityId;
    }

    protected HistoricActivityInstanceEntity findHistoricActivityInstance(ExecutionEntity execution, String activityId, boolean endTimeMustBeNull) {
        List<HistoricActivityInstanceEntity> historicActivityInstances;
        if (activityId == null) {
            return null;
        }
        String executionId = execution.getId();
        HistoricActivityInstanceEntity historicActivityInstanceEntityFromCache = this.getHistoricActivityInstanceFromCache(executionId, activityId, endTimeMustBeNull);
        if (historicActivityInstanceEntityFromCache != null) {
            return historicActivityInstanceEntityFromCache;
        }
        if (!(execution.isInserted() || execution.isProcessInstanceType() || (historicActivityInstances = this.getHistoricActivityInstanceEntityManager().findUnfinishedHistoricActivityInstancesByExecutionAndActivityId(executionId, activityId)).size() <= 0 || endTimeMustBeNull && historicActivityInstances.get(0).getEndTime() != null)) {
            return historicActivityInstances.get(0);
        }
        return null;
    }

    protected String parseActivityType(FlowElement element) {
        String elementType = element.getClass().getSimpleName();
        elementType = elementType.substring(0, 1).toLowerCase() + elementType.substring(1);
        return elementType;
    }

    protected EntityCache getEntityCache() {
        return this.getSession(EntityCache.class);
    }

    protected String getProcessDefinitionId(VariableInstanceEntity variable, ExecutionEntity sourceActivityExecution) {
        TaskEntity taskEntity;
        String processDefinitionId = null;
        if (sourceActivityExecution != null) {
            processDefinitionId = sourceActivityExecution.getProcessDefinitionId();
        } else if (variable.getProcessInstanceId() != null) {
            ExecutionEntity processInstanceExecution = (ExecutionEntity)this.processEngineConfiguration.getExecutionEntityManager().findById(variable.getProcessInstanceId());
            if (processInstanceExecution != null) {
                processDefinitionId = processInstanceExecution.getProcessDefinitionId();
            }
        } else if (variable.getTaskId() != null && (taskEntity = this.processEngineConfiguration.getTaskServiceConfiguration().getTaskService().getTask(variable.getTaskId())) != null) {
            processDefinitionId = taskEntity.getProcessDefinitionId();
        }
        return processDefinitionId;
    }
}

