/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.job;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.quartz.JobKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobNamer {
    private static final Logger LOG = LoggerFactory.getLogger(JobNamer.class);

    private static String getKeyFromJobName(String name, String pattern, int prefixLength) {
        String result = null;
        Matcher jobMatcher = Pattern.compile(pattern).matcher(name);
        if (jobMatcher.matches()) {
            try {
                result = name.substring(prefixLength);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Unparsable id: {}", (Object)name.substring(prefixLength), (Object)e);
            }
        }
        return result;
    }

    public static String getTaskKeyFromJobName(String name) {
        return JobNamer.getKeyFromJobName(name, "taskJob[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}", 7);
    }

    public static String getReportKeyFromJobName(String name) {
        return JobNamer.getKeyFromJobName(name, "reportJob[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}", 9);
    }

    public static JobKey getJobKey(Task<?> task) {
        return new JobKey("taskJob" + task.getKey(), "DEFAULT");
    }

    public static JobKey getJobKey(Report report) {
        return new JobKey("reportJob" + report.getKey(), "DEFAULT");
    }

    public static String getTriggerName(String jobName) {
        return "Trigger_" + jobName;
    }

    private JobNamer() {
    }
}

