/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.monitor;

import lombok.Generated;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class MemoryMonitorHealthIndicator
extends AbstractHealthIndicator {
    private static final int PERCENTAGE_VALUE = 100;
    private final long freeMemoryWarnThreshold;

    protected void doHealthCheck(Health.Builder builder) {
        Runtime runtime = Runtime.getRuntime();
        long used = runtime.totalMemory() - runtime.freeMemory();
        long total = runtime.maxMemory();
        long free = total - used;
        if (free * 100L / total < this.freeMemoryWarnThreshold) {
            MemoryMonitorHealthIndicator.buildHealthCheckStatus(builder.down(), free, total);
        } else {
            MemoryMonitorHealthIndicator.buildHealthCheckStatus(builder.up(), free, total);
        }
    }

    private static void buildHealthCheckStatus(Health.Builder builder, long freeMemory, long totalMemory) {
        builder.withDetail("freeMemory", (Object)freeMemory).withDetail("totalMemory", (Object)totalMemory);
    }

    @Generated
    public MemoryMonitorHealthIndicator(long freeMemoryWarnThreshold) {
        this.freeMemoryWarnThreshold = freeMemoryWarnThreshold;
    }
}

