/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.wicket.util.cookies.CookieDefaults;
import org.apache.wicket.util.cookies.CookieUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PreferenceManager
implements Serializable {
    private static final long serialVersionUID = 3581434664555284193L;
    private static final Logger LOG = LoggerFactory.getLogger(PreferenceManager.class);
    private static final String COOKIE_NAME = "syncope2ConsolePrefs";
    private static final int ONE_YEAR_TIME = 31536000;
    private static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    private static final TypeReference<Map<String, String>> MAP_TYPE_REF = new TypeReference<Map<String, String>>(){};
    private static final List<Integer> PAGINATOR_CHOICES = List.of(Integer.valueOf(10), Integer.valueOf(25), Integer.valueOf(50));
    private static final CookieUtils COOKIE_UTILS;

    public static List<Integer> getPaginatorChoices() {
        return PAGINATOR_CHOICES;
    }

    private static Map<String, String> getPrefs(String value) {
        HashMap<String, String> prefs;
        try {
            if (!StringUtils.isNotBlank((CharSequence)value)) {
                throw new Exception("Invalid cookie value '" + value + "'");
            }
            prefs = (HashMap<String, String>)MAPPER.readValue(value, MAP_TYPE_REF);
        }
        catch (Exception e) {
            LOG.debug("No preferences found", (Throwable)e);
            prefs = new HashMap<String, String>();
        }
        return prefs;
    }

    private static String setPrefs(Map<String, String> prefs) throws IOException {
        StringWriter writer = new StringWriter();
        MAPPER.writeValue((Writer)writer, prefs);
        return writer.toString();
    }

    public static String get(String key) {
        String result = null;
        String prefString = COOKIE_UTILS.load(COOKIE_NAME);
        if (prefString != null) {
            Map<String, String> prefs = PreferenceManager.getPrefs(new String(Base64.getDecoder().decode(prefString.getBytes())));
            result = prefs.get(key);
        }
        return result;
    }

    public static Integer getPaginatorRows(String key) {
        Integer result = PreferenceManager.getPaginatorChoices().get(0);
        String value = PreferenceManager.get(key);
        if (value != null) {
            result = NumberUtils.toInt((String)value, (int)10);
        }
        return result;
    }

    public static List<String> getList(String key) {
        ArrayList<String> result = new ArrayList<String>();
        String compound = PreferenceManager.get(key);
        if (StringUtils.isNotBlank((CharSequence)compound)) {
            String[] items = compound.split(";");
            result.addAll(List.of(items));
        }
        return result;
    }

    public static void set(Map<String, List<String>> prefs) {
        HashMap<String, String> current = new HashMap<String, String>();
        String prefString = COOKIE_UTILS.load(COOKIE_NAME);
        if (prefString != null) {
            current.putAll(PreferenceManager.getPrefs(new String(Base64.getDecoder().decode(prefString.getBytes()))));
        }
        prefs.forEach((key, values) -> current.put((String)key, values.stream().collect(Collectors.joining(";"))));
        try {
            COOKIE_UTILS.save(COOKIE_NAME, Base64.getEncoder().encodeToString(PreferenceManager.setPrefs(current).getBytes()));
        }
        catch (IOException e) {
            LOG.error("Could not save {} info: {}", new Object[]{PreferenceManager.class.getSimpleName(), current, e});
        }
    }

    public static void set(String key, String value) {
        String prefString = COOKIE_UTILS.load(COOKIE_NAME);
        HashMap<String, String> current = new HashMap<String, String>();
        if (prefString != null) {
            current.putAll(PreferenceManager.getPrefs(new String(Base64.getDecoder().decode(prefString.getBytes()))));
        }
        current.put(key, value);
        try {
            COOKIE_UTILS.save(COOKIE_NAME, Base64.getEncoder().encodeToString(PreferenceManager.setPrefs(current).getBytes()));
        }
        catch (IOException e) {
            LOG.error("Could not save {} info: {}", new Object[]{PreferenceManager.class.getSimpleName(), current, e});
        }
    }

    public static void setList(String key, List<String> values) {
        PreferenceManager.set(key, values.stream().collect(Collectors.joining(";")));
    }

    public static void setList(Map<String, List<String>> prefs) {
        PreferenceManager.set(prefs);
    }

    private PreferenceManager() {
    }

    static {
        CookieDefaults cookieDefaults = new CookieDefaults();
        cookieDefaults.setMaxAge(31536000);
        COOKIE_UTILS = new CookieUtils(cookieDefaults);
    }
}

