/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorAccount;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorAccountSerializer;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.util.CompressionUtils;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RestControllerEndpoint(id="gauthCredentialRepository", enableByDefault=false)
public class GoogleAuthenticatorTokenCredentialRepositoryEndpoint
extends BaseCasActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleAuthenticatorTokenCredentialRepositoryEndpoint.class);
    private final ObjectProvider<OneTimeTokenCredentialRepository> repository;

    public GoogleAuthenticatorTokenCredentialRepositoryEndpoint(CasConfigurationProperties casProperties, ObjectProvider<OneTimeTokenCredentialRepository> repository) {
        super(casProperties);
        this.repository = repository;
    }

    @GetMapping(path={"/{username}"}, produces={"application/json"})
    @Operation(summary="Load and get all accounts for the user", parameters={@Parameter(name="username", required=true)})
    public Collection<? extends OneTimeTokenAccount> get(@PathVariable String username) {
        return ((OneTimeTokenCredentialRepository)this.repository.getObject()).get(username);
    }

    @GetMapping(produces={"application/json"})
    @Operation(summary="Load and get all accounts")
    public Collection<? extends OneTimeTokenAccount> load() {
        return ((OneTimeTokenCredentialRepository)this.repository.getObject()).load();
    }

    @DeleteMapping(path={"/{username}"}, produces={"application/json"})
    @Operation(summary="Delete account for the user", parameters={@Parameter(name="username", required=true)})
    public void delete(@PathVariable String username) {
        ((OneTimeTokenCredentialRepository)this.repository.getObject()).delete(username);
    }

    @DeleteMapping(produces={"application/json"})
    @Operation(summary="Delete all accounts")
    public void deleteAll() {
        ((OneTimeTokenCredentialRepository)this.repository.getObject()).deleteAll();
    }

    @GetMapping(path={"/export"}, produces={"application/octet-stream"})
    @ResponseBody
    @Operation(summary="Export accounts as a zip file")
    public ResponseEntity<Resource> exportAccounts() {
        Collection accounts = ((OneTimeTokenCredentialRepository)this.repository.getObject()).load();
        GoogleAuthenticatorAccountSerializer serializer = new GoogleAuthenticatorAccountSerializer();
        WritableResource resource = CompressionUtils.toZipFile(accounts.stream(), (Function)Unchecked.function(entry -> {
            GoogleAuthenticatorAccount acct = (GoogleAuthenticatorAccount)entry;
            String fileName = String.format("%s-%s", acct.getName(), acct.getId());
            File sourceFile = File.createTempFile(fileName, ".json");
            serializer.to(sourceFile, acct);
            return sourceFile;
        }), (String)"gauthaccts");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentDisposition(ContentDisposition.attachment().filename(Objects.requireNonNull(resource.getFilename())).build());
        return new ResponseEntity((Object)resource, (MultiValueMap)headers, HttpStatus.OK);
    }

    @PostMapping(path={"/import"}, consumes={"application/json"})
    @Operation(summary="Import account as a JSON document", parameters={@Parameter(name="request")})
    public HttpStatus importAccount(HttpServletRequest request) throws Exception {
        String requestBody = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
        LOGGER.trace("Submitted account: [{}]", (Object)requestBody);
        GoogleAuthenticatorAccountSerializer serializer = new GoogleAuthenticatorAccountSerializer();
        GoogleAuthenticatorAccount account = (GoogleAuthenticatorAccount)serializer.from(requestBody);
        LOGGER.trace("Storing account: [{}]", (Object)account);
        ((OneTimeTokenCredentialRepository)this.repository.getObject()).save((OneTimeTokenAccount)account);
        return HttpStatus.CREATED;
    }
}

