/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.pac4j.core.context.HttpConstants;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public final class SAML2Utils
implements HttpConstants {
    private static final Logger logger = LoggerFactory.getLogger(SAML2Utils.class);
    private static final Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE");

    private SAML2Utils() {
    }

    public static String generateID() {
        return "_".concat(CommonHelper.randomString((int)39)).toLowerCase();
    }

    public static boolean urisEqualAfterPortNormalization(URI uri1, URI uri2) {
        if (uri1 == null && uri2 == null) {
            return true;
        }
        if (uri1 == null || uri2 == null) {
            return false;
        }
        try {
            URI normalizedUri1 = SAML2Utils.normalizePortNumbersInUri(uri1);
            URI normalizedUri2 = SAML2Utils.normalizePortNumbersInUri(uri2);
            boolean eq = normalizedUri1.equals(normalizedUri2);
            return eq;
        }
        catch (URISyntaxException use) {
            logger.error("Cannot compare 2 URIs.", (Throwable)use);
            return false;
        }
    }

    private static URI normalizePortNumbersInUri(URI uri) throws URISyntaxException {
        int port = uri.getPort();
        String scheme = uri.getScheme();
        if ("http".equals(scheme) && port == 80) {
            port = -1;
        }
        if ("https".equals(scheme) && port == 443) {
            port = -1;
        }
        URI result = new URI(scheme, uri.getUserInfo(), uri.getHost(), port, uri.getPath(), uri.getQuery(), uri.getFragment());
        return result;
    }

    public static ChainingMetadataResolver buildChainingMetadataResolver(SAML2MetadataResolver idpMetadataProvider, SAML2MetadataResolver spMetadataProvider) {
        ChainingMetadataResolver metadataManager = new ChainingMetadataResolver();
        metadataManager.setId(ChainingMetadataResolver.class.getCanonicalName());
        try {
            ArrayList<MetadataResolver> list = new ArrayList<MetadataResolver>();
            list.add(idpMetadataProvider.resolve());
            list.add(spMetadataProvider.resolve());
            metadataManager.setResolvers(list);
            metadataManager.initialize();
        }
        catch (ResolverException e) {
            throw new TechnicalException("Error adding idp or sp metadatas to manager", (Throwable)e);
        }
        catch (ComponentInitializationException e) {
            throw new TechnicalException("Error initializing manager", (Throwable)e);
        }
        return metadataManager;
    }

    public static void logProtocolMessage(XMLObject object) {
        if (protocolMessageLog.isDebugEnabled()) {
            try {
                String requestXml = SerializeSupport.nodeToString((Node)XMLObjectSupport.marshall((XMLObject)object));
                protocolMessageLog.debug(requestXml);
            }
            catch (MarshallingException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

