/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.FIQLQueryTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.FIQLQueryDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.FIQLQuery;
import org.apache.syncope.core.provisioning.api.data.FIQLQueryDataBinder;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class FIQLQueryLogic
extends AbstractTransactionalLogic<FIQLQueryTO> {
    protected final FIQLQueryDataBinder binder;
    protected final FIQLQueryDAO fiqlQueryDAO;
    protected final UserDAO userDAO;

    public FIQLQueryLogic(FIQLQueryDataBinder binder, FIQLQueryDAO fiqlQueryDAO, UserDAO userDAO) {
        this.binder = binder;
        this.fiqlQueryDAO = fiqlQueryDAO;
        this.userDAO = userDAO;
    }

    protected void securityChecks(String owner) {
        if (!AuthContextUtils.getUsername().equals(owner)) {
            throw new DelegatedAdministrationException("/", AnyTypeKind.USER.name(), owner);
        }
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public FIQLQueryTO read(String key) {
        FIQLQuery fiqlQuery = this.fiqlQueryDAO.find(key);
        if (fiqlQuery == null) {
            LOG.error("Could not find fiqlQuery '" + key + "'");
            throw new NotFoundException(key);
        }
        this.securityChecks(fiqlQuery.getOwner().getUsername());
        return this.binder.getFIQLQueryTO(fiqlQuery);
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public List<FIQLQueryTO> list(String target) {
        return this.fiqlQueryDAO.findByOwner(this.userDAO.findByUsername(AuthContextUtils.getUsername()), target).stream().map(arg_0 -> ((FIQLQueryDataBinder)this.binder).getFIQLQueryTO(arg_0)).collect(Collectors.toList());
    }

    @PreAuthorize(value="isAuthenticated()")
    public FIQLQueryTO create(FIQLQueryTO fiqlQueryTO) {
        return this.binder.getFIQLQueryTO(this.fiqlQueryDAO.save(this.binder.create(fiqlQueryTO)));
    }

    @PreAuthorize(value="isAuthenticated()")
    public FIQLQueryTO update(FIQLQueryTO fiqlQueryTO) {
        FIQLQuery fiqlQuery = this.fiqlQueryDAO.find(fiqlQueryTO.getKey());
        if (fiqlQuery == null) {
            LOG.error("Could not find fiqlQuery '" + fiqlQueryTO.getKey() + "'");
            throw new NotFoundException(fiqlQueryTO.getKey());
        }
        this.securityChecks(fiqlQuery.getOwner().getUsername());
        return this.binder.getFIQLQueryTO(this.fiqlQueryDAO.save(this.binder.update(fiqlQuery, fiqlQueryTO)));
    }

    @PreAuthorize(value="isAuthenticated()")
    public FIQLQueryTO delete(String key) {
        FIQLQuery fiqlQuery = this.fiqlQueryDAO.find(key);
        if (fiqlQuery == null) {
            LOG.error("Could not find fiqlQuery '" + key + "'");
            throw new NotFoundException(key);
        }
        this.securityChecks(fiqlQuery.getOwner().getUsername());
        FIQLQueryTO deleted = this.binder.getFIQLQueryTO(fiqlQuery);
        this.fiqlQueryDAO.delete(key);
        return deleted;
    }

    @Override
    protected FIQLQueryTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof FIQLQueryTO)) continue;
                key = ((FIQLQueryTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getFIQLQueryTO(this.fiqlQueryDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

