/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.internal.util;

import com.google.common.io.BaseEncoding;
import com.yubico.internal.util.ExceptionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class BinaryUtil {
    public static byte[] copy(byte[] bytes) {
        return Arrays.copyOf(bytes, bytes.length);
    }

    public static String toHex(byte[] bytes) {
        return BaseEncoding.base16().encode(bytes).toLowerCase();
    }

    public static byte[] fromHex(String hex) {
        return BaseEncoding.base16().decode((CharSequence)hex.toUpperCase());
    }

    public static byte singleFromHex(String hex) {
        ExceptionUtil.assure(hex.length() == 2, "Argument must be exactly 2 hexadecimal characters, was: %s", hex);
        return BinaryUtil.fromHex(hex)[0];
    }

    public static short getUint8(byte b) {
        return ByteBuffer.wrap(new byte[]{0, b}).order(ByteOrder.BIG_ENDIAN).getShort();
    }

    public static int getUint16(byte[] bytes) {
        if (bytes.length == 2) {
            return ByteBuffer.wrap(new byte[]{0, 0, bytes[0], bytes[1]}).order(ByteOrder.BIG_ENDIAN).getInt();
        }
        throw new IllegalArgumentException("Argument must be 2 bytes, was: " + bytes.length);
    }

    public static long getUint32(byte[] bytes) {
        if (bytes.length == 4) {
            return ByteBuffer.wrap(new byte[]{0, 0, 0, 0, bytes[0], bytes[1], bytes[2], bytes[3]}).order(ByteOrder.BIG_ENDIAN).getLong();
        }
        throw new IllegalArgumentException("Argument must be 4 bytes, was: " + bytes.length);
    }

    public static byte[] encodeUint16(int value) {
        ExceptionUtil.assure(value >= 0, "Argument must be non-negative, was: %d", value);
        ExceptionUtil.assure(value < 65536, "Argument must be smaller than 2^16=65536, was: %d", value);
        ByteBuffer b = ByteBuffer.allocate(4);
        b.order(ByteOrder.BIG_ENDIAN);
        b.putInt(value);
        b.rewind();
        return Arrays.copyOfRange(b.array(), 2, 4);
    }

    public static byte[] encodeUint32(long value) {
        ExceptionUtil.assure(value >= 0L, "Argument must be non-negative, was: %d", value);
        ExceptionUtil.assure(value < 0x100000000L, "Argument must be smaller than 2^32=4294967296, was: %d", value);
        ByteBuffer b = ByteBuffer.allocate(8);
        b.order(ByteOrder.BIG_ENDIAN);
        b.putLong(value);
        b.rewind();
        return Arrays.copyOfRange(b.array(), 4, 8);
    }

    public static byte[] readAll(InputStream is) throws IOException {
        byte[] buffer = new byte[1024];
        int bufferLen = 0;
        int moreLen;
        while ((moreLen = is.read(buffer, bufferLen, buffer.length - bufferLen)) > 0) {
            if ((bufferLen += moreLen) != buffer.length) continue;
            buffer = Arrays.copyOf(buffer, buffer.length * 2);
        }
        return Arrays.copyOf(buffer, bufferLen);
    }
}

