/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.servicenow;

import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;
import org.identityconnectors.framework.spi.StatefulConfiguration;

public class SNConnectorConfiguration
extends AbstractConfiguration
implements StatefulConfiguration {
    private String username;
    private GuardedString password;
    private String baseAddress;

    @ConfigurationProperty(order=1, displayMessageKey="baseAddress.display", helpMessageKey="baseAddress.help", required=true)
    public String getBaseAddress() {
        return this.baseAddress;
    }

    public void setBaseAddress(String baseAddress) {
        this.baseAddress = baseAddress;
    }

    @ConfigurationProperty(order=2, displayMessageKey="username.display", helpMessageKey="username.help", required=true)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @ConfigurationProperty(order=3, displayMessageKey="password.display", helpMessageKey="password.help", required=true, confidential=true)
    public GuardedString getPassword() {
        return this.password;
    }

    public void setPassword(GuardedString password) {
        this.password = password;
    }

    public void validate() {
        if (StringUtil.isBlank((String)this.baseAddress)) {
            this.failValidation("Base URL cannot be null or empty.", new Object[0]);
        }
        if (StringUtil.isBlank((String)this.username)) {
            this.failValidation("Username cannot be null or empty.", new Object[0]);
        }
        if (StringUtil.isBlank((String)SecurityUtil.decrypt((GuardedString)this.password))) {
            this.failValidation("Password Id cannot be null or empty.", new Object[0]);
        }
    }

    public void release() {
    }

    private void failValidation(String key, Object ... args) {
        String message = this.getConnectorMessages().format(key, null, args);
        throw new ConfigurationException(message);
    }
}

