/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.claims.OidcRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.mapping.OidcAttributeToScopeClaimMapper;
import org.apereo.cas.services.AbstractRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public abstract class BaseOidcScopeAttributeReleasePolicy
extends AbstractRegisteredServiceAttributeReleasePolicy
implements OidcRegisteredServiceAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseOidcScopeAttributeReleasePolicy.class);
    private static final long serialVersionUID = -7302163334687300920L;
    @JsonProperty
    private List<String> allowedAttributes;
    @JsonProperty(value="claimMappings")
    private Map<String, String> claimMappings = new TreeMap<String, String>();
    @JsonIgnore
    private String scopeType;

    protected BaseOidcScopeAttributeReleasePolicy(String scopeType) {
        this.scopeType = scopeType;
    }

    protected Optional<String> getMappedClaim(String claim, RegisteredServiceAttributeReleasePolicyContext context) {
        ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
        OidcAttributeToScopeClaimMapper mapper = (OidcAttributeToScopeClaimMapper)applicationContext.getBean("oidcAttributeToScopeClaimMapper", OidcAttributeToScopeClaimMapper.class);
        LOGGER.debug("Attempting to process claim [{}]", (Object)claim);
        return mapper.containsMappedAttribute(claim, context.getRegisteredService()) ? Optional.of(mapper.getMappedAttribute(claim, context.getRegisteredService())) : Optional.empty();
    }

    protected Pair<String, Object> mapClaimToAttribute(String claim, RegisteredServiceAttributeReleasePolicyContext context, Map<String, List<Object>> resolvedAttributes) {
        Optional<String> mappedClaimResult = this.getMappedClaim(claim, context);
        if (mappedClaimResult.isPresent()) {
            String mappedAttr = mappedClaimResult.get();
            LOGGER.trace("Attribute [{}] is mapped to claim [{}]", (Object)mappedAttr, (Object)claim);
            if (resolvedAttributes.containsKey(mappedAttr)) {
                List<Object> value = resolvedAttributes.get(mappedAttr);
                LOGGER.debug("Found mapped attribute [{}] with value [{}] for claim [{}]", new Object[]{mappedAttr, value, claim});
                return Pair.of((Object)claim, value);
            }
            if (resolvedAttributes.containsKey(claim)) {
                List<Object> value = resolvedAttributes.get(claim);
                LOGGER.debug("CAS is unable to find the attribute [{}] that is mapped to claim [{}]. However, since resolved attributes [{}] already contain this claim, CAS will use [{}] with value(s) [{}]", new Object[]{mappedAttr, claim, resolvedAttributes, claim, value});
                return Pair.of((Object)claim, value);
            }
            LOGGER.warn("Located claim [{}] mapped to attribute [{}], yet resolved attributes [{}] do not contain attribute [{}]", new Object[]{claim, mappedAttr, resolvedAttributes, mappedAttr});
        }
        List<Object> value = resolvedAttributes.get(claim);
        LOGGER.debug("No mapped attribute is defined for claim [{}]; Used [{}] to locate value [{}]", new Object[]{claim, claim, value});
        return Pair.of((Object)claim, value);
    }

    public Map<String, List<Object>> getAttributesInternal(RegisteredServiceAttributeReleasePolicyContext context, Map<String, List<Object>> attributes) {
        ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
        if (applicationContext == null) {
            LOGGER.warn("Could not locate the application context to process attributes");
            return new HashMap<String, List<Object>>(0);
        }
        TreeMap<String, List<Object>> resolvedAttributes = new TreeMap<String, List<Object>>(String.CASE_INSENSITIVE_ORDER);
        resolvedAttributes.putAll(attributes);
        HashMap attributesToRelease = Maps.newHashMapWithExpectedSize((int)attributes.size());
        LOGGER.debug("Attempting to map and filter claims based on resolved attributes [{}]", resolvedAttributes);
        CasConfigurationProperties properties = (CasConfigurationProperties)applicationContext.getBean(CasConfigurationProperties.class);
        List supportedClaims = properties.getAuthn().getOidc().getDiscovery().getClaims();
        LinkedHashSet<String> allowedClaims = new LinkedHashSet<String>(this.getAllowedAttributes());
        allowedClaims.retainAll(supportedClaims);
        LOGGER.debug("[{}] is designed to allow claims [{}] for scope [{}]. After cross-checking with supported claims [{}], the final collection of allowed attributes is [{}]", new Object[]{this.getClass().getSimpleName(), this.getAllowedAttributes(), this.getScopeType(), supportedClaims, allowedClaims});
        allowedClaims.stream().map(claim -> this.mapClaimToAttribute((String)claim, context, (Map<String, List<Object>>)resolvedAttributes)).filter(p -> Objects.nonNull(p.getValue())).forEach(p -> attributesToRelease.put((String)p.getKey(), (List)CollectionUtils.toCollection((Object)p.getValue(), ArrayList.class)));
        return attributesToRelease;
    }

    public List<String> determineRequestedAttributeDefinitions(RegisteredServiceAttributeReleasePolicyContext context) {
        ArrayList attributes = this.getAllowedAttributes();
        return attributes != null ? attributes : new ArrayList();
    }

    @Generated
    public String toString() {
        return "BaseOidcScopeAttributeReleasePolicy(super=" + super.toString() + ", allowedAttributes=" + this.allowedAttributes + ", claimMappings=" + this.claimMappings + ", scopeType=" + this.scopeType + ")";
    }

    @Override
    @Generated
    public List<String> getAllowedAttributes() {
        return this.allowedAttributes;
    }

    @Override
    @Generated
    public Map<String, String> getClaimMappings() {
        return this.claimMappings;
    }

    @Override
    @Generated
    public String getScopeType() {
        return this.scopeType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseOidcScopeAttributeReleasePolicy)) {
            return false;
        }
        BaseOidcScopeAttributeReleasePolicy other = (BaseOidcScopeAttributeReleasePolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$allowedAttributes = this.allowedAttributes;
        List<String> other$allowedAttributes = other.allowedAttributes;
        if (this$allowedAttributes == null ? other$allowedAttributes != null : !((Object)this$allowedAttributes).equals(other$allowedAttributes)) {
            return false;
        }
        Map<String, String> this$claimMappings = this.claimMappings;
        Map<String, String> other$claimMappings = other.claimMappings;
        if (this$claimMappings == null ? other$claimMappings != null : !((Object)this$claimMappings).equals(other$claimMappings)) {
            return false;
        }
        String this$scopeType = this.scopeType;
        String other$scopeType = other.scopeType;
        return !(this$scopeType == null ? other$scopeType != null : !this$scopeType.equals(other$scopeType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseOidcScopeAttributeReleasePolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $allowedAttributes = this.allowedAttributes;
        result = result * 59 + ($allowedAttributes == null ? 43 : ((Object)$allowedAttributes).hashCode());
        Map<String, String> $claimMappings = this.claimMappings;
        result = result * 59 + ($claimMappings == null ? 43 : ((Object)$claimMappings).hashCode());
        String $scopeType = this.scopeType;
        result = result * 59 + ($scopeType == null ? 43 : $scopeType.hashCode());
        return result;
    }

    @JsonProperty
    @Generated
    public void setAllowedAttributes(List<String> allowedAttributes) {
        this.allowedAttributes = allowedAttributes;
    }

    @JsonProperty(value="claimMappings")
    @Generated
    public void setClaimMappings(Map<String, String> claimMappings) {
        this.claimMappings = claimMappings;
    }

    @JsonIgnore
    @Generated
    public void setScopeType(String scopeType) {
        this.scopeType = scopeType;
    }
}

