/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.kafka;

import org.flowable.eventregistry.api.OutboundEvent;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;
import org.flowable.eventregistry.spring.kafka.KafkaPartitionProvider;

public class EventPayloadKafkaPartitionProvider
implements KafkaPartitionProvider {
    protected final String eventField;

    public EventPayloadKafkaPartitionProvider(String eventField) {
        this.eventField = eventField;
    }

    @Override
    public Integer determinePartition(OutboundEvent<?> outboundEvent) {
        for (EventPayloadInstance payloadInstance : outboundEvent.getEventInstance().getPayloadInstances()) {
            if (!this.eventField.equals(payloadInstance.getDefinitionName())) continue;
            return this.parseValue(payloadInstance.getValue());
        }
        return null;
    }

    protected Integer parseValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt(value.toString());
        }
        if (value != null) {
            throw new IllegalStateException("The [" + this.eventField + "] must resolve to an Number or a String that can be parsed as an Integer. Resolved to [" + value.getClass() + "] for [" + value + "]");
        }
        return null;
    }
}

