/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.security.Key;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20RegisteredServiceJwtAccessTokenCipherExecutor;
import org.apereo.cas.token.cipher.JwtTicketCipherExecutor;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.cipher.BaseStringCipherExecutor;
import org.jooq.lambda.Unchecked;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcRegisteredServiceJwtAccessTokenCipherExecutor
extends OAuth20RegisteredServiceJwtAccessTokenCipherExecutor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcRegisteredServiceJwtAccessTokenCipherExecutor.class);
    protected final LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> defaultJsonWebKeystoreCache;
    protected final LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> serviceJsonWebKeystoreCache;
    protected final OidcIssuerService oidcIssuerService;

    private static PublicJsonWebKey toJsonWebKey(String key) throws Exception {
        Map details = EncodingUtils.parseJsonWebKey((String)key);
        if (details.containsKey("keys")) {
            return (PublicJsonWebKey)new JsonWebKeySet(key).getJsonWebKeys().get(0);
        }
        return (PublicJsonWebKey)EncodingUtils.newJsonWebKey((String)key);
    }

    public Optional<String> getSigningKey(RegisteredService registeredService) {
        if (!this.isSigningEnabledForRegisteredService(registeredService)) {
            return Optional.empty();
        }
        Optional result = super.getSigningKey(registeredService);
        if (result.isPresent()) {
            return result;
        }
        OidcRegisteredService oidcRegisteredService = (OidcRegisteredService)OidcRegisteredService.class.cast(registeredService);
        String issuer = this.oidcIssuerService.determineIssuer(Optional.of(oidcRegisteredService));
        LOGGER.trace("Using issuer [{}] to determine JWKS from default keystore cache", (Object)issuer);
        Optional jwks = Objects.requireNonNull((Optional)this.serviceJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey((OAuthRegisteredService)oidcRegisteredService, OidcJsonWebKeyUsage.SIGNING)));
        if (jwks.isPresent()) {
            JsonWebKeySet jsonWebKey = (JsonWebKeySet)jwks.get();
            LOGGER.debug("Found JSON web key to sign the token: [{}]", (Object)jsonWebKey);
            List keys = jsonWebKey.getJsonWebKeys().stream().filter(key -> key.getKey() != null).collect(Collectors.toList());
            return Optional.of(new JsonWebKeySet(keys).toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE));
        }
        jwks = Objects.requireNonNull((Optional)this.defaultJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey(issuer, OidcJsonWebKeyUsage.SIGNING)));
        if (jwks.isEmpty()) {
            LOGGER.warn("No signing key could be found for issuer " + issuer);
            return Optional.empty();
        }
        return Optional.of(((JsonWebKeySet)jwks.get()).toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE));
    }

    public Optional<String> getEncryptionKey(RegisteredService registeredService) {
        if (!this.isEncryptionEnabledForRegisteredService(registeredService)) {
            return Optional.empty();
        }
        OAuthRegisteredService svc = (OAuthRegisteredService)registeredService;
        Optional result = super.getEncryptionKey(registeredService);
        if (result.isPresent()) {
            return result;
        }
        if (svc instanceof OidcRegisteredService) {
            Optional jwks = Objects.requireNonNull((Optional)this.serviceJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey(svc, OidcJsonWebKeyUsage.ENCRYPTION)));
            if (jwks.isEmpty()) {
                LOGGER.warn("Service " + svc.getServiceId() + " with client id " + svc.getClientId() + " is configured to encrypt tokens, yet no JSON web key is available");
                return Optional.empty();
            }
            JsonWebKeySet jsonWebKey = (JsonWebKeySet)jwks.get();
            LOGGER.debug("Found JSON web key to encrypt the token: [{}]", (Object)jsonWebKey);
            List keys = jsonWebKey.getJsonWebKeys().stream().filter(key -> key.getKey() != null).collect(Collectors.toList());
            if (keys.isEmpty()) {
                LOGGER.warn("No valid JSON web keys used to sign the token can be found");
                return Optional.empty();
            }
            return Optional.of(new JsonWebKeySet(keys).toJson());
        }
        return result;
    }

    protected JwtTicketCipherExecutor createCipherExecutorInstance(String encryptionKey, String signingKey, RegisteredService registeredService, BaseStringCipherExecutor.CipherOperationsStrategyType type) {
        InternalJwtAccessTokenCipherExecutor cipher = new InternalJwtAccessTokenCipherExecutor(encryptionKey, signingKey);
        Unchecked.consumer(c -> {
            PublicJsonWebKey jsonWebKey;
            if (EncodingUtils.isJsonWebKey((String)encryptionKey)) {
                jsonWebKey = OidcRegisteredServiceJwtAccessTokenCipherExecutor.toJsonWebKey(encryptionKey);
                cipher.setEncryptionKey(jsonWebKey.getPublicKey());
                cipher.setEncryptionWebKey((JsonWebKey)jsonWebKey);
            }
            if (EncodingUtils.isJsonWebKey((String)signingKey)) {
                jsonWebKey = OidcRegisteredServiceJwtAccessTokenCipherExecutor.toJsonWebKey(signingKey);
                cipher.setSigningKey((Key)ObjectUtils.defaultIfNull((Object)jsonWebKey.getPrivateKey(), (Object)jsonWebKey.getKey()));
                cipher.setSigningWebKey((JsonWebKey)jsonWebKey);
            }
        }).accept(cipher);
        if (EncodingUtils.isJsonWebKey((String)encryptionKey) || EncodingUtils.isJsonWebKey((String)signingKey)) {
            cipher.setEncryptionAlgorithm("RSA-OAEP-256");
        }
        cipher.setCustomHeaders(CollectionUtils.wrap((String)CUSTOM_HEADER_REGISTERED_SERVICE_ID, (Object)registeredService.getId()));
        cipher.setStrategyType(type);
        return cipher;
    }

    private Key getEncryptionKeyForDecryption(RegisteredService registeredService) {
        OAuthRegisteredService svc = (OAuthRegisteredService)registeredService;
        if (svc instanceof OidcRegisteredService) {
            Optional jwks = Objects.requireNonNull((Optional)this.serviceJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey(svc, OidcJsonWebKeyUsage.ENCRYPTION)));
            if (jwks.isEmpty()) {
                LOGGER.warn("Service " + svc.getServiceId() + " with client id " + svc.getClientId() + " is configured to encrypt tokens, yet no JSON web key is available");
                return null;
            }
            PublicJsonWebKey jsonWebKey = (PublicJsonWebKey)((JsonWebKeySet)jwks.get()).getJsonWebKeys().get(0);
            LOGGER.debug("Found JSON web key to encrypt the token: [{}]", (Object)jsonWebKey);
            if (jsonWebKey.getPrivateKey() == null) {
                LOGGER.info("JSON web key used to encrypt the token has no associated private key, when operating on service [{}] with client id [{}]. Operations that deal with JWT encryption/decryption may not be functional, until a private key can be loaded for JSON web key [{}]", new Object[]{svc.getServiceId(), svc.getClientId(), jsonWebKey.getKeyId()});
                return null;
            }
            return jsonWebKey.getPrivateKey();
        }
        return null;
    }

    @Generated
    public OidcRegisteredServiceJwtAccessTokenCipherExecutor(LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> defaultJsonWebKeystoreCache, LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> serviceJsonWebKeystoreCache, OidcIssuerService oidcIssuerService) {
        this.defaultJsonWebKeystoreCache = defaultJsonWebKeystoreCache;
        this.serviceJsonWebKeystoreCache = serviceJsonWebKeystoreCache;
        this.oidcIssuerService = oidcIssuerService;
    }

    @Generated
    public LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> getDefaultJsonWebKeystoreCache() {
        return this.defaultJsonWebKeystoreCache;
    }

    @Generated
    public LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> getServiceJsonWebKeystoreCache() {
        return this.serviceJsonWebKeystoreCache;
    }

    @Generated
    public OidcIssuerService getOidcIssuerService() {
        return this.oidcIssuerService;
    }

    private class InternalJwtAccessTokenCipherExecutor
    extends JwtTicketCipherExecutor {
        private JsonWebKey signingWebKey;
        private JsonWebKey encryptionWebKey;

        InternalJwtAccessTokenCipherExecutor(String encryptionKey, String signingKey) {
            super(encryptionKey, signingKey, StringUtils.isNotBlank((CharSequence)encryptionKey), StringUtils.isNotBlank((CharSequence)signingKey), 0, 0);
        }

        protected byte[] sign(byte[] value, Key signingKey) {
            return Optional.ofNullable(this.signingWebKey).map(key -> {
                String kid = key.getKeyId();
                if (StringUtils.isNotBlank((CharSequence)kid)) {
                    this.getCustomHeaders().put("kid", kid);
                }
                String alg = (String)StringUtils.defaultIfBlank((CharSequence)key.getAlgorithm(), (CharSequence)this.getSigningAlgorithmFor(key.getKey()));
                this.getCustomHeaders().put("alg", alg);
                return super.signWith(value, alg, signingKey);
            }).orElseGet(() -> super.sign(value, signingKey));
        }

        protected String decode(Serializable value, Object[] parameters, Key encryptionKey, Key signingKey) {
            if (parameters.length > 0) {
                RegisteredService registeredService = (RegisteredService)parameters[0];
                Key decryptionKey = OidcRegisteredServiceJwtAccessTokenCipherExecutor.this.getEncryptionKeyForDecryption(registeredService);
                return super.decode(value, parameters, decryptionKey, signingKey);
            }
            return super.decode(value, parameters, encryptionKey, signingKey);
        }

        @Generated
        public void setSigningWebKey(JsonWebKey signingWebKey) {
            this.signingWebKey = signingWebKey;
        }

        @Generated
        public void setEncryptionWebKey(JsonWebKey encryptionWebKey) {
            this.encryptionWebKey = encryptionWebKey;
        }

        @Generated
        public JsonWebKey getSigningWebKey() {
            return this.signingWebKey;
        }

        @Generated
        public JsonWebKey getEncryptionWebKey() {
            return this.encryptionWebKey;
        }
    }
}

