/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.rest;

import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.SurrogateAuthenticationException;
import org.apereo.cas.authentication.SurrogateUsernamePasswordCredential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.configuration.model.support.surrogate.SurrogateAuthenticationProperties;
import org.apereo.cas.rest.factory.UsernamePasswordRestHttpRequestCredentialFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;

public class SurrogateAuthenticationRestHttpRequestCredentialFactory
extends UsernamePasswordRestHttpRequestCredentialFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateAuthenticationRestHttpRequestCredentialFactory.class);
    public static final String REQUEST_HEADER_SURROGATE_PRINCIPAL = "X-Surrogate-Principal";
    private final SurrogateAuthenticationService surrogateAuthenticationService;
    private final SurrogateAuthenticationProperties properties;

    public int getOrder() {
        return super.getOrder() - 1;
    }

    public List<Credential> fromRequest(HttpServletRequest request, MultiValueMap<String, String> requestBody) {
        List credentials = super.fromRequest(request, requestBody);
        if (credentials.isEmpty()) {
            return credentials;
        }
        SurrogateUsernamePasswordCredential credential = (SurrogateUsernamePasswordCredential)((Object)FunctionUtils.doUnchecked(() -> this.extractCredential(request, credentials)));
        if (credential == null) {
            LOGGER.trace("Not a surrogate authentication attempt, returning parent class credentials");
            return credentials;
        }
        Collection surrogateAccounts = this.surrogateAuthenticationService.getImpersonationAccounts(credential.getId());
        if (!surrogateAccounts.contains(credential.getSurrogateUsername())) {
            throw new SurrogateAuthenticationException("Unable to authorize surrogate authentication request for " + credential.getSurrogateUsername());
        }
        return CollectionUtils.wrapList((Object[])new Credential[]{credential});
    }

    protected SurrogateUsernamePasswordCredential extractCredential(HttpServletRequest request, List<Credential> credentials) throws Exception {
        SurrogateUsernamePasswordCredential sc = new SurrogateUsernamePasswordCredential();
        UsernamePasswordCredential credential = (UsernamePasswordCredential)UsernamePasswordCredential.class.cast(credentials.get(0));
        BeanUtils.copyProperties((Object)((Object)sc), (Object)credential);
        String surrogatePrincipal = request.getHeader(REQUEST_HEADER_SURROGATE_PRINCIPAL);
        if (StringUtils.isNotBlank((CharSequence)surrogatePrincipal)) {
            LOGGER.debug("Request surrogate principal [{}]", (Object)surrogatePrincipal);
            sc.setSurrogateUsername(surrogatePrincipal);
            return sc;
        }
        String username = credential.getUsername();
        if (username.contains(this.properties.getSeparator())) {
            String surrogateUsername = username.substring(0, username.indexOf(this.properties.getSeparator()));
            String realUsername = username.substring(username.indexOf(this.properties.getSeparator()) + this.properties.getSeparator().length());
            sc.setUsername(realUsername);
            sc.setSurrogateUsername(surrogateUsername);
            sc.assignPassword(credential.toPassword());
            return sc;
        }
        return null;
    }

    @Generated
    public SurrogateAuthenticationRestHttpRequestCredentialFactory(SurrogateAuthenticationService surrogateAuthenticationService, SurrogateAuthenticationProperties properties) {
        this.surrogateAuthenticationService = surrogateAuthenticationService;
        this.properties = properties;
    }
}

