/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.beans;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ComplianceQuery
implements Serializable {
    private static final long serialVersionUID = -7324275079761880426L;
    private String username;
    private String password;
    private String realm;
    private Set<String> resources = new HashSet<String>();

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public Set<String> getResources() {
        return this.resources;
    }

    public void setResources(Set<String> resources) {
        this.resources = resources;
    }

    @JsonIgnore
    public boolean isEmpty() {
        if (StringUtils.isBlank((CharSequence)this.username) && StringUtils.isBlank((CharSequence)this.password)) {
            return true;
        }
        return StringUtils.isEmpty((CharSequence)this.realm) && this.resources.isEmpty();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComplianceQuery other = (ComplianceQuery)obj;
        return new EqualsBuilder().append((Object)this.username, (Object)other.username).append((Object)this.password, (Object)other.password).append((Object)this.realm, (Object)other.realm).append(this.resources, other.resources).build();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.username).append((Object)this.password).append((Object)this.realm).append(this.resources).build();
    }

    public static class Builder {
        private final ComplianceQuery instance = new ComplianceQuery();

        public Builder username(String username) {
            this.instance.setUsername(username);
            return this;
        }

        public Builder password(String password) {
            this.instance.setPassword(password);
            return this;
        }

        public Builder realm(String realm) {
            this.instance.setRealm(realm);
            return this;
        }

        public ComplianceQuery build() {
            return this.instance;
        }

        public Builder resource(String resource) {
            if (resource != null) {
                this.instance.getResources().add(resource);
            }
            return this;
        }

        public Builder resources(String ... resources) {
            this.instance.getResources().addAll(List.of(resources));
            return this;
        }

        public Builder resources(Collection<String> resources) {
            if (resources != null) {
                this.instance.getResources().addAll(resources);
            }
            return this;
        }
    }
}

