/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html;

import org.apache.wicket.Component;
import org.apache.wicket.IGenericComponent;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IObjectClassAwareModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.validation.IValidator;

public class AjaxEditableLabel<T>
extends Panel
implements IGenericComponent<T, AjaxEditableLabel<T>> {
    private static final long serialVersionUID = 1L;
    private FormComponent<T> editor;
    private Component label;

    protected void updateLabelAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    protected void updateEditorAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    public AjaxEditableLabel(String id) {
        super(id);
        this.setOutputMarkupId(true);
    }

    public AjaxEditableLabel(String id, IModel<T> model) {
        super(id, model);
        this.setOutputMarkupId(true);
    }

    public final AjaxEditableLabel<T> add(IValidator<T> validator) {
        this.getEditor().add(validator);
        return this;
    }

    public final AjaxEditableLabel<T> setLabel(IModel<String> labelModel) {
        this.getEditor().setLabel(labelModel);
        return this;
    }

    public final AjaxEditableLabel<T> setDefaultModel(IModel<?> model) {
        super.setDefaultModel(model);
        this.getLabel().setDefaultModel(model);
        this.getEditor().setDefaultModel(model);
        return this;
    }

    public final AjaxEditableLabel<T> setRequired(boolean required) {
        this.getEditor().setRequired(required);
        return this;
    }

    public final AjaxEditableLabel<T> setType(Class<?> type) {
        this.getEditor().setType(type);
        return this;
    }

    protected FormComponent<T> newEditor(MarkupContainer parent, String componentId, IModel<T> model) {
        TextField editor = new TextField<T>(componentId, model){
            private static final long serialVersionUID = 1L;

            protected boolean shouldTrimInput() {
                return AjaxEditableLabel.this.shouldTrimInput();
            }

            public <C> IConverter<C> getConverter(Class<C> type) {
                return AjaxEditableLabel.this.getConverter(type);
            }

            protected void onModelChanged() {
                super.onModelChanged();
                AjaxEditableLabel.this.onModelChanged();
            }

            protected void onModelChanging() {
                super.onModelChanging();
                AjaxEditableLabel.this.onModelChanging();
            }
        };
        editor.setOutputMarkupId(true);
        editor.setVisible(false);
        editor.add(new Behavior[]{new EditorAjaxBehavior(){

            @Override
            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.setEventNames(new String[]{"blur", "keyup", "keydown"});
                attributes.setPreventDefault(false);
                String precondition = "var kc=Wicket.Event.keyCode(attrs.event),evtType=attrs.event.type,ret=false;if (evtType==='blur' || (evtType==='keyup' && kc===27) || (evtType==='keydown' && kc===13)) {attrs.event.preventDefault(); ret = true;}return ret;";
                AjaxCallListener ajaxCallListener = new AjaxCallListener();
                ajaxCallListener.onPrecondition((CharSequence)precondition);
                String dynamicExtraParameters = "var result,evtType=attrs.event.type;if (evtType === 'keyup') { result = { 'save': false }; }else { result = { 'save': true }; }return result;";
                attributes.getDynamicExtraParameters().add(dynamicExtraParameters);
                attributes.getAjaxCallListeners().add(ajaxCallListener);
            }
        }});
        return editor;
    }

    protected boolean shouldTrimInput() {
        return true;
    }

    protected Component newLabel(MarkupContainer parent, String componentId, IModel<T> model) {
        Label label = new Label(componentId, model){
            private static final long serialVersionUID = 1L;

            public <C> IConverter<C> getConverter(Class<C> type) {
                return AjaxEditableLabel.this.getConverter(type);
            }

            public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
                Object modelObject = this.getDefaultModelObject();
                if (modelObject == null || modelObject instanceof String && ((String)modelObject).isEmpty()) {
                    this.replaceComponentTagBody(markupStream, openTag, AjaxEditableLabel.this.defaultNullLabel());
                } else {
                    super.onComponentTagBody(markupStream, openTag);
                }
            }
        };
        label.setOutputMarkupId(true);
        label.add(new Behavior[]{new LabelAjaxBehavior(this.getLabelAjaxEvent())});
        return label;
    }

    protected String getLabelAjaxEvent() {
        return "click";
    }

    protected final FormComponent<T> getEditor() {
        if (this.editor == null) {
            this.initLabelAndEditor(new WrapperModel());
        }
        return this.editor;
    }

    protected final Component getLabel() {
        if (this.label == null) {
            this.initLabelAndEditor(new WrapperModel());
        }
        return this.label;
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        if (this.editor == null) {
            this.initLabelAndEditor(new WrapperModel());
        }
    }

    protected void onCancel(AjaxRequestTarget target) {
        this.label.setVisible(true);
        this.editor.setVisible(false);
        this.editor.clearInput();
        target.add(new Component[]{this});
    }

    public void onEdit(AjaxRequestTarget target) {
        this.label.setVisible(false);
        this.editor.setVisible(true);
        target.add(new Component[]{this});
        String selectScript = String.format("(function(){var el = Wicket.$('%s'); if (el.select) el.select();})()", this.editor.getMarkupId());
        target.appendJavaScript((CharSequence)selectScript);
        target.focusComponent(this.editor);
    }

    protected void onError(AjaxRequestTarget target) {
        if (this.editor.hasErrorMessage()) {
            FeedbackMessage errorMessage = this.editor.getFeedbackMessages().first(400);
            target.appendJavaScript((CharSequence)("window.status='" + JavaScriptUtils.escapeQuotes((CharSequence)errorMessage.toString()) + "';"));
        }
        String selectAndFocusScript = String.format("(function(){var el=Wicket.$('%s'); if (el.select) el.select(); el.focus();})()", this.editor.getMarkupId());
        target.appendJavaScript((CharSequence)selectAndFocusScript);
    }

    protected void onSubmit(AjaxRequestTarget target) {
        this.label.setVisible(true);
        this.editor.setVisible(false);
        target.add(new Component[]{this});
        target.appendJavaScript((CharSequence)"window.status='';");
    }

    private void initLabelAndEditor(IModel<T> model) {
        this.editor = this.newEditor((MarkupContainer)this, "editor", model);
        this.label = this.newLabel((MarkupContainer)this, "label", model);
        this.add(new Component[]{this.label});
        this.add(new Component[]{this.editor});
    }

    private IModel<T> getParentModel() {
        IModel m = this.getModel();
        if (m == null) {
            MarkupContainer parent = this.getParent();
            Object msg = "No model found for this component, either pass one explicitly or make sure an inheritable model is available.";
            if (parent == null) {
                msg = (String)msg + " This component is not added to a parent yet, so if this component is supposed to use the model of the parent (e.g. when it uses a compound property model), add it first before further configuring the component calling methods like e.g. setType and addValidator.";
            }
            throw new IllegalStateException((String)msg);
        }
        return m;
    }

    protected String defaultNullLabel() {
        return "...";
    }

    protected void onModelChanged() {
        super.onModelChanged();
    }

    protected void onModelChanging() {
        super.onModelChanging();
    }

    private class WrapperModel
    implements IModel<T>,
    IObjectClassAwareModel<T> {
        private WrapperModel() {
        }

        public T getObject() {
            return AjaxEditableLabel.this.getParentModel().getObject();
        }

        public void setObject(T object) {
            AjaxEditableLabel.this.getParentModel().setObject(object);
        }

        public void detach() {
            AjaxEditableLabel.this.getParentModel().detach();
        }

        public Class<T> getObjectClass() {
            if (AjaxEditableLabel.this.getParentModel() instanceof IObjectClassAwareModel) {
                return ((IObjectClassAwareModel)AjaxEditableLabel.this.getParentModel()).getObjectClass();
            }
            return null;
        }
    }

    protected class LabelAjaxBehavior
    extends AjaxEventBehavior {
        private static final long serialVersionUID = 1L;

        public LabelAjaxBehavior(String event) {
            super(event);
        }

        protected void onEvent(AjaxRequestTarget target) {
            AjaxEditableLabel.this.onEdit(target);
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            AjaxEditableLabel.this.updateLabelAjaxAttributes(attributes);
        }
    }

    protected class EditorAjaxBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        protected EditorAjaxBehavior() {
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            AjaxEditableLabel.this.updateEditorAjaxAttributes(attributes);
        }

        public void renderHead(Component component, IHeaderResponse response) {
            super.renderHead(component, response);
            AjaxEditableLabel.this.getRequestCycle().find(IPartialPageRequestHandler.class).ifPresent(target -> target.appendJavaScript(this.getCallbackScript(component)));
        }

        protected void respond(AjaxRequestTarget target) {
            RequestCycle requestCycle = RequestCycle.get();
            boolean save = requestCycle.getRequest().getRequestParameters().getParameterValue("save").toBoolean(false);
            if (save) {
                AjaxEditableLabel.this.editor.processInput();
                if (AjaxEditableLabel.this.editor.isValid()) {
                    AjaxEditableLabel.this.onSubmit(target);
                } else {
                    AjaxEditableLabel.this.onError(target);
                }
            } else {
                AjaxEditableLabel.this.onCancel(target);
            }
        }
    }
}

