/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.concurrent;

public final class SetOnceRef<V> {
    private V ref;
    private boolean set;
    private final boolean allowsNullValue;

    public SetOnceRef() {
        this(null, false, false);
    }

    public SetOnceRef(V ref) {
        this(ref, false, true);
    }

    public SetOnceRef(V ref, boolean allowNull) {
        this(ref, allowNull, true);
    }

    public SetOnceRef(boolean allowNull) {
        this(null, allowNull, false);
    }

    private SetOnceRef(V ref, boolean allowNull, boolean init) {
        this.allowsNullValue = allowNull;
        if (init) {
            this.set(ref);
        }
    }

    public boolean allowsNull() {
        return this.allowsNullValue;
    }

    public synchronized void set(V ref) {
        if (this.set) {
            throw new IllegalStateException("Reference has already been set");
        }
        if (!this.allowsNull() && ref == null) {
            throw new IllegalArgumentException("This instance cannot hold a null reference value");
        }
        this.set = true;
        this.ref = ref;
    }

    public synchronized V get() {
        if (!this.set) {
            throw new IllegalStateException("Reference has not been set");
        }
        return this.ref;
    }

    public synchronized boolean isSet() {
        return this.set;
    }
}

