/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.terracotta.dynamic_config.api.model.ClusterState;
import org.terracotta.dynamic_config.api.model.Operation;
import org.terracotta.dynamic_config.api.model.Scope;

public class Permission {
    private final Collection<ClusterState> clusterStates;
    private final Collection<Operation> operations;
    private final Collection<Scope> levels;

    private Permission(Collection<ClusterState> clusterStates, Collection<Operation> operations, Collection<Scope> levels) {
        this.clusterStates = new HashSet<ClusterState>(clusterStates);
        this.operations = new HashSet<Operation>(operations);
        this.levels = new HashSet<Scope>(levels);
    }

    public boolean allows(Scope scope) {
        return this.levels.contains((Object)scope);
    }

    public boolean allows(Operation operation) {
        return this.operations.contains((Object)operation);
    }

    public boolean allows(ClusterState clusterState) {
        return this.clusterStates.contains((Object)clusterState);
    }

    public boolean isUserExportable() {
        return this.allows(ClusterState.CONFIGURING) && this.allows(Operation.GET);
    }

    public boolean isWritableWhen(ClusterState clusterState) {
        return this.allows(clusterState) && (this.allows(Operation.SET) || this.allows(Operation.UNSET) || this.allows(Operation.IMPORT));
    }

    public String toString() {
        return "Permission: when: " + this.clusterStates + " allow: " + this.operations + " at levels: " + this.levels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Permission)) {
            return false;
        }
        Permission that = (Permission)o;
        return this.clusterStates.equals(that.clusterStates) && this.operations.equals(that.operations) && this.levels.equals(that.levels);
    }

    public int hashCode() {
        return Objects.hash(this.clusterStates, this.operations, this.levels);
    }

    public static class Builder {
        private final Collection<ClusterState> clusterStates = new HashSet<ClusterState>();
        private final Collection<Operation> operations = new HashSet<Operation>();

        private Builder(Collection<ClusterState> clusterStates) {
            this.clusterStates.addAll(clusterStates);
        }

        public static Builder when(ClusterState ... clusterStates) {
            return new Builder(Arrays.asList(clusterStates));
        }

        public Builder allow(Operation ... operations) {
            for (ClusterState clusterState : this.clusterStates) {
                for (Operation operation : operations) {
                    if (clusterState.supports(operation)) continue;
                    throw new IllegalArgumentException("state: " + (Object)((Object)clusterState) + " is not compatible with operation: " + (Object)((Object)operation));
                }
            }
            this.operations.addAll(Arrays.asList(operations));
            return this;
        }

        public Builder allowAnyOperations() {
            return this.allow(EnumSet.allOf(Operation.class).toArray(new Operation[0]));
        }

        public Permission atLevel(Scope level) {
            return this.atLevels(level);
        }

        public Permission atAnyLevels() {
            return this.atLevels(EnumSet.allOf(Scope.class).toArray(new Scope[0]));
        }

        public Permission atLevels(Scope ... levels) {
            List<Scope> levelList = Arrays.asList(levels);
            if (this.operations.contains((Object)Operation.IMPORT) && levelList.size() != 1) {
                throw new IllegalArgumentException((Object)((Object)Operation.IMPORT) + " operation is only compatible with one of " + Arrays.toString((Object[])Scope.values()));
            }
            return new Permission(this.clusterStates, this.operations, levelList);
        }
    }
}

