/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.utils;

import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import org.terracotta.runnel.utils.CorruptDataException;
import org.terracotta.runnel.utils.LimitReachedException;
import org.terracotta.runnel.utils.StringTool;
import org.terracotta.runnel.utils.VLQ;

public class ReadBuffer {
    private static final boolean V1_STRING_DECODING = false;
    private final ByteBuffer byteBuffer;
    private final int limit;

    public ReadBuffer(ByteBuffer byteBuffer) {
        this(byteBuffer, byteBuffer.remaining());
    }

    private ReadBuffer(ByteBuffer byteBuffer, int limit) {
        this.byteBuffer = byteBuffer;
        this.limit = byteBuffer.position() + limit;
        if (this.limit > byteBuffer.capacity()) {
            throw new LimitReachedException();
        }
    }

    public Boolean getBoolean() {
        if (this.byteBuffer.position() + 1 > this.limit) {
            throw new LimitReachedException();
        }
        return this.byteBuffer.get() == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public Double getDouble() {
        if (this.byteBuffer.position() + 8 > this.limit) {
            throw new LimitReachedException();
        }
        return this.byteBuffer.getDouble();
    }

    public Long getLong() {
        if (this.byteBuffer.position() + 8 > this.limit) {
            throw new LimitReachedException();
        }
        return this.byteBuffer.getLong();
    }

    public Character getChar() {
        if (this.byteBuffer.position() + 2 > this.limit) {
            throw new LimitReachedException();
        }
        return Character.valueOf(this.byteBuffer.getChar());
    }

    public Integer getInt() {
        if (this.byteBuffer.position() + 4 > this.limit) {
            throw new LimitReachedException();
        }
        return this.byteBuffer.getInt();
    }

    public int getVlqInt() {
        return VLQ.decode(this);
    }

    byte getByte() {
        if (this.byteBuffer.position() + 1 > this.limit) {
            throw new LimitReachedException();
        }
        return this.byteBuffer.get();
    }

    public ByteBuffer getByteBuffer(int size) {
        if (this.byteBuffer.position() + size > this.limit) {
            throw new LimitReachedException();
        }
        ByteBuffer slice = this.byteBuffer.slice();
        slice.limit(size);
        this.byteBuffer.position(this.byteBuffer.position() + size);
        return slice;
    }

    public String getString(int size) {
        if (this.byteBuffer.position() + size > this.limit) {
            throw new LimitReachedException();
        }
        ByteBuffer slice = this.byteBuffer.slice();
        slice.limit(size);
        String s = this.readString(slice);
        this.byteBuffer.position(this.byteBuffer.position() + size);
        return s;
    }

    private String readString(ByteBuffer binary) {
        try {
            String ret = StringTool.attemptDecodeAsAscii(binary);
            if (ret != null) {
                return ret;
            }
            return StringTool.decodeString(binary, binary.remaining());
        }
        catch (UTFDataFormatException e) {
            CorruptDataException cde = new CorruptDataException("Unexpected encoding");
            cde.addSuppressed(e);
            throw cde;
        }
    }

    public boolean limitReached() {
        return this.byteBuffer.position() == this.limit;
    }

    public void skipAll() {
        this.byteBuffer.position(this.limit);
    }

    public void skip(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size cannot be < 0");
        }
        int targetPosition = this.byteBuffer.position() + size;
        if (targetPosition > this.limit) {
            throw new LimitReachedException();
        }
        this.byteBuffer.position(targetPosition);
    }

    public ReadBuffer limit(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size cannot be < 0");
        }
        return new ReadBuffer(this.byteBuffer, size);
    }
}

