/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ActionExecutor;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ActionTransitionCriteria
implements TransitionCriteria {
    private String[] trueEventIds = new String[]{"success", "yes", "true"};
    private Action action;

    public ActionTransitionCriteria(Action action) {
        this.action = action;
    }

    public String[] getTrueEventIds() {
        return this.trueEventIds;
    }

    public void setTrueEventIds(String ... trueEventIds) {
        this.trueEventIds = trueEventIds;
    }

    protected Action getAction() {
        return this.action;
    }

    @Override
    public boolean test(RequestContext context) {
        Event result = ActionExecutor.execute(this.getAction(), context);
        return result != null && this.isTrueEvent(result.getId());
    }

    private boolean isTrueEvent(String eventId) {
        for (String trueEventId : this.trueEventIds) {
            if (!trueEventId.equals(eventId)) continue;
            return true;
        }
        return false;
    }
}

