/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.azure;

import java.util.Arrays;
import java.util.List;
import net.tirasa.connid.bundles.azure.utils.AzureFilter;
import net.tirasa.connid.bundles.azure.utils.AzureFilterOp;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.filter.AbstractFilterTranslator;
import org.identityconnectors.framework.common.objects.filter.AttributeFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsFilter;
import org.identityconnectors.framework.common.objects.filter.EndsWithFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsIgnoreCaseFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;

public class AzureFilterTranslator
extends AbstractFilterTranslator<AzureFilter> {
    private static final Log LOG = Log.getLog(AzureFilterTranslator.class);
    private final ObjectClass objectClass;

    public AzureFilterTranslator(ObjectClass objectClass) {
        this.objectClass = objectClass;
    }

    public AzureFilter createAndExpression(AzureFilter leftExpression, AzureFilter rightExpression) {
        return this.createAzureFilter(AzureFilterOp.AND, null, false, Arrays.asList(leftExpression, rightExpression), false);
    }

    public AzureFilter createOrExpression(AzureFilter leftExpression, AzureFilter rightExpression) {
        return this.createAzureFilter(AzureFilterOp.OR, null, false, Arrays.asList(leftExpression, rightExpression), false);
    }

    public AzureFilter createContainsExpression(ContainsFilter filter, boolean not) {
        return this.createAzureFilter(AzureFilterOp.CONTAINS, (AttributeFilter)filter, true, null, not);
    }

    public AzureFilter createEndsWithExpression(EndsWithFilter filter, boolean not) {
        return this.createAzureFilter(AzureFilterOp.ENDS_WITH, (AttributeFilter)filter, true, null, not);
    }

    public AzureFilter createStartsWithExpression(StartsWithFilter filter, boolean not) {
        return this.createAzureFilter(AzureFilterOp.STARTS_WITH, (AttributeFilter)filter, true, null, not);
    }

    public AzureFilter createGreaterThanExpression(GreaterThanFilter filter, boolean not) {
        return this.createAzureFilter(AzureFilterOp.GREATER_THAN, (AttributeFilter)filter, true, null, not);
    }

    public AzureFilter createGreaterThanOrEqualExpression(GreaterThanOrEqualFilter filter, boolean not) {
        return this.createAzureFilter(AzureFilterOp.GREATER_OR_EQUAL, (AttributeFilter)filter, true, null, not);
    }

    public AzureFilter createLessThanExpression(LessThanFilter filter, boolean not) {
        return this.createAzureFilter(AzureFilterOp.LESS_THAN, (AttributeFilter)filter, true, null, not);
    }

    public AzureFilter createLessThanOrEqualExpression(LessThanOrEqualFilter filter, boolean not) {
        return this.createAzureFilter(AzureFilterOp.LESS_OR_EQUAL, (AttributeFilter)filter, true, null, not);
    }

    public AzureFilter createEqualsExpression(EqualsFilter filter, boolean not) {
        return this.createAzureFilter(AzureFilterOp.EQUALS, (AttributeFilter)filter, true, null, not);
    }

    public AzureFilter createEqualsIgnoreCaseExpression(EqualsIgnoreCaseFilter filter, boolean not) {
        return this.createAzureFilter(AzureFilterOp.EQUALS, (AttributeFilter)filter, true, null, not);
    }

    private AzureFilter createAzureFilter(AzureFilterOp type, AttributeFilter filter, boolean quote, List<AzureFilter> filters, boolean not) {
        this.checkIfNot(not);
        return filter == null ? new AzureFilter(type, null, null, quote, filters) : new AzureFilter(type, filter.getAttribute(), this.getFilterValue(filter), quote, filters);
    }

    private String getFilterName(AttributeFilter filter) {
        if (ObjectClass.GROUP == this.objectClass) {
            return "objectId".equals(filter.getName()) || Name.NAME.equals(filter.getName()) ? filter.getName() : "profile." + filter.getName();
        }
        return "objectId".equals(filter.getName()) ? filter.getName() : "profile." + filter.getName();
    }

    private Object getFilterValue(AttributeFilter filter) {
        Object attrValue = AttributeUtil.getSingleValue((Attribute)filter.getAttribute());
        if (attrValue == null) {
            return null;
        }
        return attrValue;
    }

    private void checkIfNot(boolean not) {
        if (not) {
            LOG.info("Search with not is not supported by Okta", new Object[0]);
        }
    }
}

