/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.EntityTO;

public class LinkedAccountTO
implements EntityTO {
    private static final long serialVersionUID = 7396929732310559535L;
    private String key;
    private String connObjectKeyValue;
    private String resource;
    private String username;
    private String password;
    private boolean suspended;
    private final Set<Attr> plainAttrs = new TreeSet<Attr>();
    private final Set<String> privileges = new TreeSet<String>();

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    public String getConnObjectKeyValue() {
        return this.connObjectKeyValue;
    }

    public void setConnObjectKeyValue(String connObjectKeyValue) {
        this.connObjectKeyValue = connObjectKeyValue;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    @JacksonXmlElementWrapper(localName="plainAttrs")
    @JacksonXmlProperty(localName="plainAttr")
    public Set<Attr> getPlainAttrs() {
        return this.plainAttrs;
    }

    @JsonIgnore
    public Optional<Attr> getPlainAttr(String schema) {
        return this.plainAttrs.stream().filter(attr -> attr.getSchema().equals(schema)).findFirst();
    }

    @JacksonXmlElementWrapper(localName="privileges")
    @JacksonXmlProperty(localName="privilege")
    public Set<String> getPrivileges() {
        return this.privileges;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.key).append((Object)this.connObjectKeyValue).append((Object)this.resource).append((Object)this.username).append(this.suspended).append(this.plainAttrs).append(this.privileges).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkedAccountTO other = (LinkedAccountTO)obj;
        return new EqualsBuilder().append((Object)this.key, (Object)other.key).append((Object)this.connObjectKeyValue, (Object)other.connObjectKeyValue).append((Object)this.resource, (Object)other.resource).append((Object)this.username, (Object)other.username).append(this.suspended, other.suspended).append(this.plainAttrs, other.plainAttrs).append(this.privileges, other.privileges).build();
    }

    public static class Builder {
        private final LinkedAccountTO instance = new LinkedAccountTO();

        public Builder(String resource, String connObjectKeyValue) {
            this(null, resource, connObjectKeyValue);
        }

        public Builder(String key, String resource, String connObjectKeyValue) {
            this.instance.setKey(key);
            this.instance.setResource(resource);
            this.instance.setConnObjectKeyValue(connObjectKeyValue);
        }

        public Builder username(String username) {
            this.instance.setUsername(username);
            return this;
        }

        public Builder password(String password) {
            this.instance.setPassword(password);
            return this;
        }

        public Builder suspended(boolean suspended) {
            this.instance.setSuspended(suspended);
            return this;
        }

        public LinkedAccountTO build() {
            return this.instance;
        }
    }
}

