/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authorization;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.ldaptive.FilterTemplate;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchResponse;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseUseAttributesAuthorizationGenerator
implements AuthorizationGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseUseAttributesAuthorizationGenerator.class);
    private final SearchOperation userSearchOperation;
    private final boolean allowMultipleResults;

    protected void addProfileRoles(LdapEntry userEntry, UserProfile profile, LdapAttribute attribute, String prefix) {
        this.addProfileRolesFromAttributes(profile, attribute, prefix);
    }

    protected void addProfileRolesFromAttributes(UserProfile profile, LdapAttribute ldapAttribute, String prefix) {
        ldapAttribute.getStringValues().forEach(value -> profile.addRole(prefix.concat(value.toUpperCase())));
    }

    public Optional<UserProfile> generate(WebContext context, SessionStore sessionStore, UserProfile profile) {
        String username = profile.getId();
        LOGGER.debug("Attempting to get details for user [{}].", (Object)username);
        FilterTemplate filter = LdapUtils.newLdaptiveSearchFilter(this.userSearchOperation.getTemplate().getFilter(), "user", (List<String>)CollectionUtils.wrap((Object)username));
        SearchResponse response = (SearchResponse)FunctionUtils.doUnchecked(() -> this.userSearchOperation.execute(filter));
        LOGGER.debug("LDAP user search response: [{}]", (Object)response);
        if (!this.allowMultipleResults && response.entrySize() > 1) {
            throw new IllegalStateException("Found multiple results for user which is not allowed.");
        }
        if (response.entrySize() > 0) {
            LdapEntry userEntry = response.getEntry();
            return this.generateAuthorizationForLdapEntry(profile, userEntry);
        }
        return Optional.of(profile);
    }

    protected abstract Optional<UserProfile> generateAuthorizationForLdapEntry(UserProfile var1, LdapEntry var2);

    @Generated
    protected BaseUseAttributesAuthorizationGenerator(SearchOperation userSearchOperation, boolean allowMultipleResults) {
        this.userSearchOperation = userSearchOperation;
        this.allowMultipleResults = allowMultipleResults;
    }

    @Generated
    public SearchOperation getUserSearchOperation() {
        return this.userSearchOperation;
    }

    @Generated
    public boolean isAllowMultipleResults() {
        return this.allowMultipleResults;
    }
}

