/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.attributes.Attributes;

public class AttributeUtil {
    public static Collection getClassesWithAttributeType(Collection classes, Class attributeClass) {
        if (classes == null) {
            throw new NullPointerException("classes");
        }
        if (attributeClass == null) {
            throw new NullPointerException("attributeClass");
        }
        ArrayList<Class> result = new ArrayList<Class>();
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            Class clazz = (Class)iter.next();
            if (clazz == null || !Attributes.hasAttributeType(clazz, attributeClass)) continue;
            result.add(clazz);
        }
        return result;
    }

    public static Collection getObjectsWithAttributeType(Collection objects, Class attributeClass) {
        if (objects == null) {
            throw new NullPointerException("objects");
        }
        if (attributeClass == null) {
            throw new NullPointerException("attributeClass");
        }
        ArrayList result = new ArrayList();
        Iterator iter = objects.iterator();
        while (iter.hasNext()) {
            Class<?> clazz;
            Object object = iter.next();
            if (object == null || !Attributes.hasAttributeType(clazz = object.getClass(), attributeClass)) continue;
            result.add(object);
        }
        return result;
    }
}

