/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.scribe.service;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class WechatService
extends OAuth20Service {
    private final String apiKey;
    private final String apiSecrect;

    public WechatService(DefaultApi20 api, String apiKey, String apiSecret, String callback, String scope, String responseType, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        super(api, apiKey, apiSecret, callback, scope, responseType, null, userAgent, httpClientConfig, httpClient);
        this.apiKey = apiKey;
        this.apiSecrect = apiSecret;
    }

    public <R> Future<R> execute(OAuthRequest request, OAuthAsyncRequestCallback<R> callback, OAuthRequest.ResponseConverter<R> converter) {
        OAuthRequest authRequest = this.addClientAuthentication(request);
        return super.execute(authRequest, callback, converter);
    }

    public Response execute(OAuthRequest request) throws InterruptedException, ExecutionException, IOException {
        OAuthRequest authRequest = this.addClientAuthentication(request);
        return super.execute(authRequest);
    }

    private OAuthRequest addClientAuthentication(OAuthRequest request) {
        request.addParameter("appid", this.apiKey);
        request.addParameter("secret", this.apiSecrect);
        return request;
    }
}

