/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.oauth2.useragent;

import com.microsoft.alm.oauth2.useragent.Provider;
import com.microsoft.alm.oauth2.useragent.Version;
import com.microsoft.alm.oauth2.useragent.utils.PackageLocator;
import com.microsoft.alm.oauth2.useragent.utils.StringHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.SWT;

public class StandardWidgetToolkitProvider
extends Provider {
    public static final String SWT_RUNTIME_JAR_OVERRIDE = "SWT_RUNTIME_JAR_PATH";
    private static final File SWT_HOME = new File(USER_HOME, ".swt");
    private static final String SWT_JAR_NAME = StandardWidgetToolkitProvider.getSwtRuntimeJarName();
    private static final File DEFAULT_SWT_RUNTIME_JAR = new File(SWT_HOME, SWT_JAR_NAME);
    private static final String JAVA_VERSION_REQUIREMENT = "Oracle Java SE or OpenJDK, version 6 and higher";
    private static final String ECLIPSE_SWT_RUNTIME_REQUIREMENT = "Standard Widget Toolkit Runtime at " + DEFAULT_SWT_RUNTIME_JAR;
    private static final String GUI_DESKTOP_ENVIRONMENT_REQUIREMENT = "A desktop environment.";
    private static final PackageLocator packageLocator = new PackageLocator();
    static PackageLocator PACKAGE_LOCATOR_OVERRIDE = null;

    static String getSwtRuntimeJarName() {
        String swtRuntimeFormatter = "swt-%s.jar";
        String swtArch = OS_ARCH.contains("64") ? "x86_64" : "x86";
        return String.format("swt-%s.jar", swtArch);
    }

    protected StandardWidgetToolkitProvider() {
        super("StandardWidgetToolkit");
    }

    public static String getDefaultSwtJarPath() {
        return DEFAULT_SWT_RUNTIME_JAR.getAbsolutePath();
    }

    @Override
    public List<String> checkRequirements() {
        ArrayList<String> requirements = new ArrayList<String>();
        Version javaVersion = Version.parseJavaRuntimeVersion(JAVA_RUNTIME_VERSION);
        if (!StandardWidgetToolkitProvider.isJavaVersion6AndUp(javaVersion)) {
            requirements.add(JAVA_VERSION_REQUIREMENT);
        }
        if (StandardWidgetToolkitProvider.getSwtRuntimeJar(DEFAULT_SWT_RUNTIME_JAR) == null) {
            requirements.add(ECLIPSE_SWT_RUNTIME_REQUIREMENT);
        }
        if (!StandardWidgetToolkitProvider.hasDesktop(OS_NAME, ENV_DISPLAY)) {
            requirements.add(GUI_DESKTOP_ENVIRONMENT_REQUIREMENT);
        }
        return requirements;
    }

    @Override
    public void augmentProcessParameters(List<String> command, List<String> classPath) {
        File swtJar = StandardWidgetToolkitProvider.getSwtRuntimeJar(DEFAULT_SWT_RUNTIME_JAR);
        if (swtJar != null) {
            classPath.add(swtJar.getAbsolutePath());
        }
        StandardWidgetToolkitProvider.relayProperties(command);
        if (StandardWidgetToolkitProvider.isMac(OS_NAME)) {
            command.add("-XstartOnFirstThread");
        }
    }

    static boolean isJavaVersion6AndUp(Version javaVersion) {
        int javaMajorVersion = javaVersion.getMajor();
        int javaMinorVersion = javaVersion.getMinor();
        return javaMajorVersion > 1 || javaMajorVersion == 1 && javaMinorVersion >= 6;
    }

    static File getSwtRuntimeJar(File defaultRuntimeJar) {
        File overrideSwtJar;
        File swtRuntime = null;
        String overrideSwtJarPath = System.getProperty(SWT_RUNTIME_JAR_OVERRIDE);
        if (!StringHelper.isNullOrWhiteSpace(overrideSwtJarPath) && (overrideSwtJar = new File(overrideSwtJarPath)).isFile()) {
            swtRuntime = overrideSwtJar;
        }
        if (swtRuntime == null) {
            PackageLocator locator = PACKAGE_LOCATOR_OVERRIDE == null ? packageLocator : PACKAGE_LOCATOR_OVERRIDE;
            try {
                File swtClasspathJar;
                swtRuntime = swtClasspathJar = locator.locatePackage(SWT.class);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (swtRuntime == null && defaultRuntimeJar.isFile()) {
            swtRuntime = defaultRuntimeJar;
        }
        return swtRuntime;
    }

    static void relayProperties(List<String> command) {
        if (StandardWidgetToolkitProvider.isLinux(OS_NAME)) {
            StandardWidgetToolkitProvider.relayNetworkProperties(command);
        }
        StandardWidgetToolkitProvider.relayProperty(command, "org.eclipse.swt.browser.XULRunnerPath");
        StandardWidgetToolkitProvider.relayProperty(command, "org.eclipse.swt.browser.MOZ_PROFILE_PATH");
    }

    static void relayNetworkProperties(List<String> command) {
        List<String> httpProxyPortProps;
        String proxyPort;
        List<String> httpProxyHostProps = Arrays.asList("https.proxyHost", "http.proxyHost", "network.proxy_host");
        String proxyHost = StandardWidgetToolkitProvider.getFirstSetProperty(httpProxyHostProps);
        if (!StringHelper.isNullOrEmpty(proxyHost)) {
            command.add("-Dnetwork.proxy_host=" + proxyHost);
        }
        if (!StringHelper.isNullOrEmpty(proxyPort = StandardWidgetToolkitProvider.getFirstSetProperty(httpProxyPortProps = Arrays.asList("https.proxyPort", "http.proxyPort", "network.proxy_port")))) {
            command.add("-Dnetwork.proxy_port=" + proxyPort);
        }
    }

    static void relayProperty(List<String> command, String propertyName) {
        String value = System.getProperty(propertyName);
        if (!StringHelper.isNullOrEmpty(value)) {
            command.add(String.format("-D%s=%s", propertyName, value));
        }
    }

    static String getFirstSetProperty(List<String> potentials) {
        String property = null;
        for (String name : potentials) {
            String value = System.getProperty(name);
            if (StringHelper.isNullOrWhiteSpace(value)) continue;
            property = value;
            break;
        }
        return property;
    }
}

