/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.egrid.column;

import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.wicketstuff.egrid.column.EditableCellPanel;
import org.wicketstuff.egrid.column.EditableGridActionsPanel;
import org.wicketstuff.egrid.column.IEditableGridColumn;

public abstract class AbstractEditablePropertyColumn<T, S>
extends PropertyColumn<T, S>
implements IEditableGridColumn {
    private static final long serialVersionUID = 1L;
    private boolean isEditable = true;

    public AbstractEditablePropertyColumn(IModel<String> displayModel, String propertyExpression) {
        super(displayModel, propertyExpression);
    }

    public AbstractEditablePropertyColumn(IModel<String> displayModel, String propertyExpression, boolean isEditable) {
        super(displayModel, propertyExpression);
        this.isEditable = isEditable;
    }

    public final void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> rowModel) {
        Item rowItem = (Item)item.findParent(Item.class);
        if (this.inEditiingMode(rowItem) && this.isEditable) {
            EditableCellPanel provider = this.getEditableCellPanel(componentId);
            FormComponent<?> editorComponent = provider.getEditableComponent();
            editorComponent.setDefaultModel(this.getDataModel(rowModel));
            item.add(new Component[]{provider});
        } else {
            super.populateItem(item, componentId, rowModel);
        }
    }

    private boolean inEditiingMode(Item<T> rowItem) {
        return (Boolean)rowItem.getMetaData(EditableGridActionsPanel.EDITING);
    }

    protected void addBehaviors(FormComponent<T> editorComponent) {
    }
}

