/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression;

import java.sql.Timestamp;
import java.util.Objects;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public final class TimestampValue
extends ASTNodeAccessImpl
implements Expression {
    private Timestamp value;
    private String rawValue;
    private static final char QUOTATION = '\'';

    public TimestampValue() {
    }

    public TimestampValue(String string) {
        this.setRawValue(Objects.requireNonNull(string, "The Timestamp string value must not be null."));
    }

    @Override
    public final void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public final Timestamp getValue() {
        return this.value;
    }

    public final void setValue(Timestamp timestamp) {
        this.value = timestamp;
    }

    public final String getRawValue() {
        return this.rawValue;
    }

    public final void setRawValue(String string) {
        this.rawValue = string;
        if (string.charAt(0) == '\'') {
            this.value = Timestamp.valueOf(string.substring(1, string.length() - 1));
            return;
        }
        this.value = Timestamp.valueOf(string.substring(0, string.length()));
    }

    public final String toString() {
        return "{ts '" + this.value + "'}";
    }

    public final TimestampValue withValue(Timestamp timestamp) {
        this.setValue(timestamp);
        return this;
    }
}

