/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.translator;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinBaseVisitor;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.process.traversal.DT;
import org.apache.tinkerpop.gremlin.process.traversal.GType;
import org.apache.tinkerpop.gremlin.process.traversal.Merge;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Pick;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public class TranslateVisitor
extends GremlinBaseVisitor<Void> {
    protected final String graphTraversalSourceName;
    protected final StringBuilder sb = new StringBuilder();
    protected final Set<String> parameters = new HashSet<String>();

    public TranslateVisitor() {
        this("g");
    }

    public TranslateVisitor(String graphTraversalSourceName) {
        this.graphTraversalSourceName = graphTraversalSourceName;
    }

    public String getTranslated() {
        return this.sb.toString();
    }

    public Set<String> getParameters() {
        return this.parameters;
    }

    protected String processGremlinSymbol(String step) {
        return step;
    }

    protected void appendArgumentSeparator() {
        this.sb.append(", ");
    }

    protected void appendStepSeparator() {
        this.sb.append(".");
    }

    protected void appendStepOpen() {
        this.sb.append("(");
    }

    protected void appendStepClose() {
        this.sb.append(")");
    }

    protected static String removeFirstAndLastCharacters(String text) {
        return text != null && !text.isEmpty() ? text.substring(1, text.length() - 1) : "";
    }

    public Void visitTraversalSource(GremlinParser.TraversalSourceContext ctx) {
        this.sb.append(this.graphTraversalSourceName);
        if (ctx.getChildCount() > 1) {
            if (ctx.getChild(0).getChildCount() > 1) {
                this.appendStepSeparator();
                this.visitTraversalSourceSelfMethod((GremlinParser.TraversalSourceSelfMethodContext)ctx.getChild(0).getChild(2));
            }
            this.appendStepSeparator();
            this.visitTraversalSourceSelfMethod((GremlinParser.TraversalSourceSelfMethodContext)ctx.getChild(2));
        }
        return null;
    }

    public Void visitNestedTraversal(GremlinParser.NestedTraversalContext ctx) {
        if (ctx.ANON_TRAVERSAL_ROOT() == null) {
            this.appendAnonymousSpawn();
        }
        return (Void)this.visitChildren((RuleNode)ctx);
    }

    public Void visitTraversalScope(GremlinParser.TraversalScopeContext ctx) {
        this.appendExplicitNaming(ctx.getText(), Scope.class.getSimpleName());
        return null;
    }

    public Void visitTraversalT(GremlinParser.TraversalTContext ctx) {
        this.appendExplicitNaming(ctx.getText(), T.class.getSimpleName());
        return null;
    }

    public Void visitTraversalMerge(GremlinParser.TraversalMergeContext ctx) {
        this.appendExplicitNaming(ctx.getText(), Merge.class.getSimpleName());
        return null;
    }

    public Void visitTraversalOrder(GremlinParser.TraversalOrderContext ctx) {
        this.appendExplicitNaming(ctx.getText(), Order.class.getSimpleName());
        return null;
    }

    public Void visitTraversalBarrier(GremlinParser.TraversalBarrierContext ctx) {
        this.appendExplicitNaming(ctx.getText(), SackFunctions.Barrier.class.getSimpleName());
        return null;
    }

    public Void visitTraversalDirection(GremlinParser.TraversalDirectionContext ctx) {
        this.appendExplicitNaming(ctx.getText(), Direction.class.getSimpleName());
        return null;
    }

    public Void visitTraversalCardinality(GremlinParser.TraversalCardinalityContext ctx) {
        if (ctx.LPAREN() != null && ctx.RPAREN() != null) {
            int idx = ctx.K_CARDINALITY() != null ? 2 : 0;
            String txt = ctx.getChild(idx).getText();
            this.appendExplicitNaming(txt, this.getCardinalityFunctionClass());
            this.appendStepOpen();
            this.visit((ParseTree)ctx.genericLiteral());
            this.appendStepClose();
        } else {
            this.appendExplicitNaming(ctx.getText(), "Cardinality");
        }
        return null;
    }

    public Void visitTraversalColumn(GremlinParser.TraversalColumnContext ctx) {
        this.appendExplicitNaming(ctx.getText(), Column.class.getSimpleName());
        return null;
    }

    public Void visitTraversalPop(GremlinParser.TraversalPopContext ctx) {
        this.appendExplicitNaming(ctx.getText(), Pop.class.getSimpleName());
        return null;
    }

    public Void visitTraversalOperator(GremlinParser.TraversalOperatorContext ctx) {
        this.appendExplicitNaming(ctx.getText(), Operator.class.getSimpleName());
        return null;
    }

    public Void visitTraversalPick(GremlinParser.TraversalPickContext ctx) {
        this.appendExplicitNaming(ctx.getText(), Pick.class.getSimpleName());
        return null;
    }

    public Void visitTraversalDT(GremlinParser.TraversalDTContext ctx) {
        this.appendExplicitNaming(ctx.getText(), DT.class.getSimpleName());
        return null;
    }

    public Void visitTraversalGType(GremlinParser.TraversalGTypeContext ctx) {
        this.appendExplicitNaming(ctx.getText(), GType.class.getSimpleName());
        return null;
    }

    public Void visitTraversalPredicate(GremlinParser.TraversalPredicateContext ctx) {
        switch (ctx.getChildCount()) {
            case 1: {
                this.visit(ctx.getChild(0));
                break;
            }
            case 5: {
                this.visit(ctx.getChild(0));
                this.sb.append(".").append(this.processGremlinSymbol("negate")).append("()");
                break;
            }
            case 6: {
                int childIndexOfParameterOperator = 2;
                boolean childIndexOfCaller = false;
                int childIndexOfArgument = 4;
                this.visit(ctx.getChild(0));
                this.sb.append(".").append(this.processGremlinSymbol(ctx.getChild(2).getText())).append("(");
                this.visit(ctx.getChild(4));
                this.sb.append(")");
            }
        }
        return null;
    }

    public Void visitTraversalPredicate_eq(GremlinParser.TraversalPredicate_eqContext ctx) {
        this.visitP((ParserRuleContext)ctx, P.class, "eq");
        return null;
    }

    public Void visitTraversalPredicate_neq(GremlinParser.TraversalPredicate_neqContext ctx) {
        this.visitP((ParserRuleContext)ctx, P.class, "neq");
        return null;
    }

    protected void visitP(ParserRuleContext ctx, Class<?> clazzOfP, String methodName) {
        this.sb.append(clazzOfP.getSimpleName());
        this.appendStepSeparator();
        this.sb.append(this.processGremlinSymbol(methodName));
        this.appendStepOpen();
        List list = ctx.children.stream().filter(t -> t instanceof GremlinParser.GenericArgumentContext || t instanceof GremlinParser.GenericArgumentVarargsContext || t instanceof GremlinParser.StringArgumentContext || t instanceof GremlinParser.StringLiteralContext || t instanceof GremlinParser.TraversalGTypeContext || t instanceof GremlinParser.TraversalPredicateContext).collect(Collectors.toList());
        for (int ix = 0; ix < list.size(); ++ix) {
            this.visit((ParseTree)list.get(ix));
            if (ix >= list.size() - 1) continue;
            this.appendArgumentSeparator();
        }
        this.appendStepClose();
    }

    public Void visitTraversalPredicate_lt(GremlinParser.TraversalPredicate_ltContext ctx) {
        this.visitP((ParserRuleContext)ctx, P.class, "lt");
        return null;
    }

    public Void visitTraversalPredicate_lte(GremlinParser.TraversalPredicate_lteContext ctx) {
        this.visitP((ParserRuleContext)ctx, P.class, "lte");
        return null;
    }

    public Void visitTraversalPredicate_gt(GremlinParser.TraversalPredicate_gtContext ctx) {
        this.visitP((ParserRuleContext)ctx, P.class, "gt");
        return null;
    }

    public Void visitTraversalPredicate_gte(GremlinParser.TraversalPredicate_gteContext ctx) {
        this.visitP((ParserRuleContext)ctx, P.class, "gte");
        return null;
    }

    public Void visitTraversalPredicate_inside(GremlinParser.TraversalPredicate_insideContext ctx) {
        this.visitP((ParserRuleContext)ctx, P.class, "inside");
        return null;
    }

    public Void visitTraversalPredicate_outside(GremlinParser.TraversalPredicate_outsideContext ctx) {
        this.visitP((ParserRuleContext)ctx, P.class, "outside");
        return null;
    }

    public Void visitTraversalPredicate_between(GremlinParser.TraversalPredicate_betweenContext ctx) {
        this.visitP((ParserRuleContext)ctx, P.class, "between");
        return null;
    }

    public Void visitTraversalPredicate_within(GremlinParser.TraversalPredicate_withinContext ctx) {
        this.visitP((ParserRuleContext)ctx, P.class, "within");
        return null;
    }

    public Void visitTraversalPredicate_without(GremlinParser.TraversalPredicate_withoutContext ctx) {
        this.visitP((ParserRuleContext)ctx, P.class, "without");
        return null;
    }

    public Void visitTraversalPredicate_typeOf(GremlinParser.TraversalPredicate_typeOfContext ctx) {
        this.visitP((ParserRuleContext)ctx, P.class, "typeOf");
        return null;
    }

    public Void visitTraversalPredicate_not(GremlinParser.TraversalPredicate_notContext ctx) {
        this.visitP((ParserRuleContext)ctx, P.class, "not");
        return null;
    }

    public Void visitTraversalPredicate_containing(GremlinParser.TraversalPredicate_containingContext ctx) {
        this.visitP((ParserRuleContext)ctx, TextP.class, "containing");
        return null;
    }

    public Void visitTraversalPredicate_notContaining(GremlinParser.TraversalPredicate_notContainingContext ctx) {
        this.visitP((ParserRuleContext)ctx, TextP.class, "notContaining");
        return null;
    }

    public Void visitTraversalPredicate_startingWith(GremlinParser.TraversalPredicate_startingWithContext ctx) {
        this.visitP((ParserRuleContext)ctx, TextP.class, "startingWith");
        return null;
    }

    public Void visitTraversalPredicate_notStartingWith(GremlinParser.TraversalPredicate_notStartingWithContext ctx) {
        this.visitP((ParserRuleContext)ctx, TextP.class, "notStartingWith");
        return null;
    }

    public Void visitTraversalPredicate_endingWith(GremlinParser.TraversalPredicate_endingWithContext ctx) {
        this.visitP((ParserRuleContext)ctx, TextP.class, "endingWith");
        return null;
    }

    public Void visitTraversalPredicate_notEndingWith(GremlinParser.TraversalPredicate_notEndingWithContext ctx) {
        this.visitP((ParserRuleContext)ctx, TextP.class, "notEndingWith");
        return null;
    }

    public Void visitTraversalPredicate_regex(GremlinParser.TraversalPredicate_regexContext ctx) {
        this.visitP((ParserRuleContext)ctx, TextP.class, "regex");
        return null;
    }

    public Void visitTraversalPredicate_notRegex(GremlinParser.TraversalPredicate_notRegexContext ctx) {
        this.visitP((ParserRuleContext)ctx, TextP.class, "notRegex");
        return null;
    }

    public Void visitBooleanArgument(GremlinParser.BooleanArgumentContext ctx) {
        if (ctx.booleanLiteral() != null) {
            this.visitBooleanLiteral(ctx.booleanLiteral());
        } else {
            this.visitVariable(ctx.variable());
        }
        return null;
    }

    public Void visitGenericArgument(GremlinParser.GenericArgumentContext ctx) {
        if (ctx.genericLiteral() != null) {
            this.visitGenericLiteral(ctx.genericLiteral());
        } else {
            this.visitVariable(ctx.variable());
        }
        return null;
    }

    public Void visitIntegerLiteral(GremlinParser.IntegerLiteralContext ctx) {
        this.sb.append(ctx.getText().toLowerCase());
        return null;
    }

    public Void visitFloatLiteral(GremlinParser.FloatLiteralContext ctx) {
        if (ctx.infLiteral() != null) {
            return (Void)this.visit((ParseTree)ctx.infLiteral());
        }
        if (ctx.nanLiteral() != null) {
            return (Void)this.visit((ParseTree)ctx.nanLiteral());
        }
        this.sb.append(ctx.getText().toLowerCase());
        return null;
    }

    public Void visitBooleanLiteral(GremlinParser.BooleanLiteralContext ctx) {
        this.sb.append(ctx.getText());
        return null;
    }

    public Void visitNullLiteral(GremlinParser.NullLiteralContext ctx) {
        this.sb.append(ctx.getText());
        return null;
    }

    public Void visitNanLiteral(GremlinParser.NanLiteralContext ctx) {
        this.sb.append(ctx.getText());
        return null;
    }

    public Void visitInfLiteral(GremlinParser.InfLiteralContext ctx) {
        this.sb.append(ctx.getText());
        return null;
    }

    public Void visitUuidLiteral(GremlinParser.UuidLiteralContext ctx) {
        this.sb.append(ctx.getText());
        return null;
    }

    public Void visitVariable(GremlinParser.VariableContext ctx) {
        String var = ctx.getText();
        this.sb.append(var);
        this.parameters.add(var);
        return null;
    }

    public Void visitKeyword(GremlinParser.KeywordContext ctx) {
        String keyword = ctx.getText();
        if (ctx.getParent() instanceof GremlinParser.MapKeyContext || ctx.getParent() instanceof GremlinParser.ConfigurationContext) {
            this.sb.append(keyword);
        } else {
            this.sb.append(keyword).append(" ");
        }
        return null;
    }

    public Void visitTerminal(TerminalNode node) {
        String terminal;
        if (null == node || node.getSymbol().getType() == -1) {
            return null;
        }
        switch (terminal = node.getSymbol().getText()) {
            case "(": {
                this.appendStepOpen();
                break;
            }
            case ")": {
                this.appendStepClose();
                break;
            }
            case ",": {
                this.appendArgumentSeparator();
                break;
            }
            case ".": {
                this.appendStepSeparator();
                break;
            }
            case "new": {
                this.sb.append("new");
                if (node.getParent() instanceof GremlinParser.MapKeyContext) break;
                this.sb.append(" ");
                break;
            }
            default: {
                this.sb.append(this.processGremlinSymbol(terminal));
            }
        }
        return null;
    }

    public Void visitTraversalTShort(GremlinParser.TraversalTShortContext ctx) {
        this.appendExplicitNaming(ctx.getText(), T.class.getSimpleName());
        return null;
    }

    public Void visitTraversalTLong(GremlinParser.TraversalTLongContext ctx) {
        this.appendExplicitNaming(ctx.getText(), T.class.getSimpleName());
        return null;
    }

    public Void visitTraversalDirectionShort(GremlinParser.TraversalDirectionShortContext ctx) {
        this.appendExplicitNaming(ctx.getText(), Direction.class.getSimpleName());
        return null;
    }

    public Void visitTraversalDirectionLong(GremlinParser.TraversalDirectionLongContext ctx) {
        this.appendExplicitNaming(ctx.getText(), Direction.class.getSimpleName());
        return null;
    }

    protected void appendExplicitNaming(String txt, String prefix) {
        if (!txt.startsWith(prefix + ".")) {
            this.sb.append(this.processGremlinSymbol(prefix)).append(".");
            this.sb.append(this.processGremlinSymbol(txt));
        } else {
            String[] split = txt.split("\\.");
            this.sb.append(this.processGremlinSymbol(split[0])).append(".");
            this.sb.append(this.processGremlinSymbol(split[1]));
        }
    }

    protected void appendAnonymousSpawn() {
        this.sb.append("__.");
    }

    protected String getCardinalityFunctionClass() {
        return VertexProperty.Cardinality.class.getSimpleName();
    }
}

