/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValueHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class VertexStepPlaceholder<E extends Element>
extends FlatMapStep<Vertex, E>
implements GValueHolder<Vertex, E>,
VertexStepContract<E> {
    private GValue<String>[] edgeLabels;
    private Direction direction;
    private final Class<E> returnClass;

    public VertexStepPlaceholder(Traversal.Admin traversal, Class<E> returnClass, Direction direction, GValue<String> ... edgeLabels) {
        super(traversal);
        this.direction = direction;
        this.edgeLabels = edgeLabels;
        this.returnClass = returnClass;
        for (GValue<String> label : edgeLabels) {
            if (!label.isVariable()) continue;
            traversal.getGValueManager().register(label);
        }
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public String[] getEdgeLabels() {
        this.traversal.getGValueManager().pinGValues(Arrays.asList(this.edgeLabels));
        return (String[])Arrays.stream(GValue.resolveToValues(this.edgeLabels)).toArray(String[]::new);
    }

    @Override
    public GValue<String>[] getEdgeLabelsAsGValues() {
        return this.edgeLabels;
    }

    @Override
    public Class<E> getReturnClass() {
        return this.returnClass;
    }

    @Override
    public void reverseDirection() {
        this.direction = this.direction.opposite();
    }

    @Override
    public boolean returnsVertex() {
        return this.returnClass.equals(Vertex.class);
    }

    @Override
    public boolean returnsEdge() {
        return this.returnClass.equals(Edge.class);
    }

    @Override
    protected Iterator<E> flatMap(Traverser.Admin<Vertex> traverser) {
        throw new IllegalStateException("VertexStepPlaceholder is not executable");
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, new Object[]{this.direction, Arrays.asList(this.edgeLabels), this.returnClass.getSimpleName().toLowerCase()});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VertexStepPlaceholder that = (VertexStepPlaceholder)o;
        return Objects.equals(this.sortEdgeLabels(this.edgeLabels), this.sortEdgeLabels(that.edgeLabels)) && this.direction == that.direction && Objects.equals(this.returnClass, that.returnClass);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.sortEdgeLabels(this.edgeLabels), this.direction, this.returnClass});
    }

    @Override
    public VertexStepPlaceholder<E> clone() {
        VertexStepPlaceholder clone = (VertexStepPlaceholder)super.clone();
        clone.direction = this.direction;
        clone.edgeLabels = new GValue[this.edgeLabels.length];
        for (int i = 0; i < this.edgeLabels.length; ++i) {
            clone.edgeLabels[i] = this.edgeLabels[i].clone();
        }
        return clone;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    public VertexStep<E> asConcreteStep() {
        VertexStep<E> step = new VertexStep<E>(this.traversal, this.returnClass, this.direction, (String[])Arrays.stream(GValue.resolveToValues(this.edgeLabels)).map(String.class::cast).toArray(String[]::new));
        TraversalHelper.copyLabels(this, step, false);
        return step;
    }

    @Override
    public boolean isParameterized() {
        return Arrays.stream(this.edgeLabels).anyMatch(gv -> gv.isVariable());
    }

    @Override
    public void updateVariable(String name, Object value) {
        for (int i = 0; i < this.edgeLabels.length; ++i) {
            if (!name.equals(this.edgeLabels[i].getName())) continue;
            this.edgeLabels[i] = GValue.ofString(name, (String)value);
        }
    }

    @Override
    public Collection<GValue<?>> getGValues() {
        return Arrays.asList(this.edgeLabels);
    }

    @Override
    public void close() throws Exception {
        this.closeIterator();
    }

    private List<GValue<String>> sortEdgeLabels(GValue<String>[] gValues) {
        if (this.edgeLabels == null || this.edgeLabels.length == 0) {
            return List.of();
        }
        List<GValue<String>> sortedEdgeLabels = Arrays.stream(this.edgeLabels).sorted(Comparator.nullsLast(new Comparator<GValue<String>>(){

            @Override
            public int compare(GValue<String> o1, GValue<String> o2) {
                if (o1.isVariable() && !o2.isVariable()) {
                    return -1;
                }
                if (!o1.isVariable() && o2.isVariable()) {
                    return 1;
                }
                if (o1.isVariable()) {
                    if (!o2.getName().equals(o1.getName())) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return o1.get().compareTo(o2.get());
                }
                return o1.get().compareTo(o2.get());
            }
        })).collect(Collectors.toList());
        return sortedEdgeLabels;
    }
}

